/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.extend.api.enumerate.InterfaceCodeEnum;
import com.els.modules.extend.api.utils.SrmInterfaceUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class SapApiItemUtils {
    private static final Logger log = LoggerFactory.getLogger(SapApiItemUtils.class);
    @Resource
    private SrmInterfaceUtil srmInterfaceUtil;

    public JSONObject callSap(InterfaceCodeEnum interfaceCodeEnum, String paramStr) {
        Long start = System.currentTimeMillis();
        JSONObject paramsObj = SapApiItemUtils.buildParamsObj(paramStr);
        try {
            String result = this.srmInterfaceUtil.call(interfaceCodeEnum, paramsObj, null, null);
            log.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u6210\u529f \u63a5\u53e3\u7f16\u7801\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            if (ObjectUtils.isEmpty((Object)result)) {
                throw new ELSBootException("\u63a8\u9001SAP\u5931\u8d25");
            }
            JSONObject resultObj = SapApiItemUtils.parseResultObj(result);
            return resultObj;
        }
        catch (ELSBootException e) {
            log.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u5931\u8d25 \u63a5\u53e3\u7f16\u7801\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            throw new ELSBootException("\u63a8\u9001SAP\u5931\u8d25:" + e.getMessage());
        }
    }

    public static JSONObject parseResultObj(String resultStr) {
        JSONObject messageObj = JSONObject.parseObject((String)resultStr).getJSONObject("MESSAGE");
        return messageObj;
    }

    public static JSONObject buildParamsObj(String paramStr) {
        JSONObject headerObj = new JSONObject();
        headerObj.put("HEADER", (Object)JSONObject.parseArray((String)paramStr));
        JSONObject baseInfoObj = new JSONObject();
        baseInfoObj.put("REQ_TRACE_ID", (Object)"");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        baseInfoObj.put("REQ_SEND_TIME", (Object)dateFormat.format(new Date()));
        baseInfoObj.put("REQ_SRC_SYS", (Object)"SRM");
        baseInfoObj.put("REQ_TAR_SYS", (Object)"SAP");
        baseInfoObj.put("REQ_SYSEVRI", (Object)"");
        baseInfoObj.put("REQ_SERVICE_NAME", (Object)"");
        baseInfoObj.put("REQ_SYN_FLAG", (Object)"");
        JSONObject requestObj = new JSONObject();
        requestObj.put("REQ_BASEINFO", (Object)baseInfoObj);
        requestObj.put("MESSAGE", (Object)headerObj);
        JSONObject parmasObj = new JSONObject();
        parmasObj.put("I_REQUEST", (Object)requestObj);
        return parmasObj;
    }
}

