/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.RedisUtil;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.extend.api.enumerate.InterfaceCodeEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SrmInterfaceUtil {
    private static final Logger logger = LoggerFactory.getLogger(SrmInterfaceUtil.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;
    private static String INTERFACE_PLATFORM_KEY = "sys:thirdAuth:interfaceToken:";
    private static String INTERFACE_PLATFORM_URL = "/els/openApi/invoke";

    public String call(InterfaceCodeEnum interfaceCodeEnum, Object obj, JSONObject headerParam, JSONObject urlParam) {
        JSONObject param = new JSONObject();
        String elsAccount = this.purchaseAccount;
        param.put("bus_account", (Object)elsAccount);
        param.put("interface_code", (Object)interfaceCodeEnum.getValue());
        param.put("url_param", (Object)urlParam);
        param.put("header_param", (Object)headerParam);
        param.put("body", obj);
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)param));
        JSONObject result = this.callInterface(elsAccount, param);
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8fd4\u56de\u63a5\u53e3\uff1a" + JSONObject.toJSONString((Object)result));
        Boolean success = result.getBoolean("success");
        if (null == success || !success.booleanValue()) {
            throw new ELSBootException(JSONObject.toJSONString((Object)result));
        }
        String interfaceResult = result.getString("result");
        if (null == interfaceResult || StringUtils.isBlank((CharSequence)interfaceResult)) {
            throw new ELSBootException(JSONObject.toJSONString((Object)result));
        }
        return interfaceResult;
    }

    public static String getDate(Date date) {
        return null == date ? "" : DateUtils.date2Str((Date)date, (SimpleDateFormat)((SimpleDateFormat)DateUtils.getDatetimeFormat().get()));
    }

    private JSONObject callInterface(String elsAccount, JSONObject param) {
        JSONObject authObj = this.getAuthObj(elsAccount);
        StringBuilder url = new StringBuilder(authObj.getString("appUrl"));
        url.append(INTERFACE_PLATFORM_URL);
        String result = ((HttpRequest)HttpRequest.post((String)url.toString()).header("token", authObj.getString("token"))).body(param.toJSONString()).execute().body();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        return resultObj;
    }

    private JSONObject getAuthObj(String elsAccount) {
        JSONObject authObj = (JSONObject)this.redisUtil.get(INTERFACE_PLATFORM_KEY + elsAccount);
        if (authObj != null) {
            return authObj;
        }
        try {
            ThirdAuthDTO authDTO = this.invokeAccountRpcService.getThirdAuthByType(elsAccount, "0");
            if (authDTO == null) {
                throw new ELSBootException("\u672a\u914d\u7f6e\u63a5\u53e3\u5e73\u53f0\u51ed\u8bc1\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
            StringBuilder url = new StringBuilder(authDTO.getAppUrl());
            url.append("/els/openApi/getToken").append("?key=").append(authDTO.getAppKey()).append("&secret=").append(authDTO.getAppSecret());
            String result = HttpUtil.get((String)url.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            int code = resultObj.getIntValue("code");
            if (code == 200) {
                authObj = new JSONObject();
                String token = resultObj.getJSONObject("result").getString("token");
                long expiresIn = resultObj.getJSONObject("result").getLongValue("expiresIn");
                authObj.put("token", (Object)token);
                authObj.put("appUrl", (Object)authDTO.getAppUrl());
                this.redisUtil.set(INTERFACE_PLATFORM_KEY + elsAccount, (Object)authObj, expiresIn - 200L);
                return authObj;
            }
            throw new ELSBootException("\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0token\u5931\u8d25\uff01");
        }
        catch (Exception var11) {
            logger.error("InterfaceUtil_getToken_failed:", (Throwable)var11);
            throw var11;
        }
    }
}

