/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.oa.dto.OAInterfaceParamDTO;
import com.els.modules.extend.api.oa.dto.OAInterfaceResultDTO;
import com.els.modules.extend.api.oa.entity.OAInterfaceParam;
import com.els.modules.extend.api.oa.enumerate.OAInterfaceBusInessTypeEnum;
import com.els.modules.extend.api.oa.service.OAInterfaceParamService;
import com.els.modules.extend.api.oa.service.UseOAInterfaceService;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UseOAInterfaceServiceImpl
implements UseOAInterfaceService {
    private static final Logger log = LoggerFactory.getLogger(UseOAInterfaceServiceImpl.class);
    @Autowired
    private OAInterfaceParamService oaInterfaceParamService;
    @Autowired
    private InterfaceUtil interfaceUtil;
    private static String tepmlate = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n    xmlns:web=\"http://webservice.review.km.kmss.landray.com/\">\n    <soapenv:Header>\n        <tns:RequestSOAPHeader xmlns:tns=\"http://sys.webservice.client\">\n            <tns:user>${uerName}</tns:user>\n            <tns:password>${passWord}</tns:password>\n        </tns:RequestSOAPHeader>\n    </soapenv:Header>\n    <soapenv:Body>\n        <web:addReview>\n            <arg0 xmlns=\"\">\n                <attachmentForms>\n                    <fdKey />\n                    <fdFileName />\n                    <fdAttachment />\n                </attachmentForms>\n                <attachmentValues />\n                <complainID />\n                <docContent></docContent>\n                <!-- \u53d1\u8d77\u4ebaOA\u5de5\u53f7 -->\n                <docCreator>${docCreator}</docCreator>\n                <docProperty />\n                 <!-- \u53d1\u8d77\u72b6\u6001 10\uff1a\u8349\u7a3f\uff0c20\u5728\u5ba1\u6838 -->\n                <docStatus>${docStatus}</docStatus>\n                <docSubject></docSubject>\n                <executiveRepID />\n                <expensesCheckID />\n                <expensesID></expensesID>\n                <fdId />\n                <fdKeyword />\n                <fdSource />\n                <!-- \u6d41\u7a0b\u6a21\u677f\uff0c\u6d4b\u8bd5\u548c\u751f\u4ea7\u4e0d\u4e00\u6837 -->\n                <fdTemplateId>${fdTemplat}</fdTemplateId>\n                <formValues>${formValues}</formValues>\n                <ID />\n                <suspensePayID />\n            </arg0>\n        </web:addReview>\n    </soapenv:Body>\n</soapenv:Envelope>";

    @Override
    public OAInterfaceResultDTO pushDataToOA(String businessType, OAInterfaceParamDTO paramDTO) {
        OAInterfaceParam oaInterfaceParam = this.oaInterfaceParamService.getDataByBusinessType(businessType);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("uerName", oaInterfaceParam.getUserName());
        params.put("passWord", oaInterfaceParam.getPassword());
        params.put("fdTemplat", oaInterfaceParam.getFlowTemplateId());
        params.put("docCreator", paramDTO.getWorkNo());
        params.put("docStatus", oaInterfaceParam.getLaunchStatus());
        params.put("formValues", paramDTO.getFormValues().toString());
        String templateText = TemplateParseUtil.getTemplateText((String)"", (String)tepmlate, params);
        JSONObject param = new JSONObject();
        param.put("srm_interface_code", (Object)OAInterfaceBusInessTypeEnum.getInterfaceCodeByValue(businessType));
        param.put("bus_account", (Object)TenantContext.getTenant());
        param.put("body", (Object)templateText);
        log.info("useOAInterfaceServiceImple\u63a5\u53e3\u5165\u53c2" + param.toString());
        JSONObject result = this.interfaceUtil.callInterface(TenantContext.getTenant(), "", param, (Object)"");
        OAInterfaceResultDTO oaInterfaceResultDTO = this.dealResult(businessType, result);
        return oaInterfaceResultDTO;
    }

    OAInterfaceResultDTO dealResult(String businessType, JSONObject result) {
        OAInterfaceResultDTO oaInterfaceResultDTO = new OAInterfaceResultDTO();
        Assert.isTrue((result.getIntValue("code") == 200 ? 1 : 0) != 0, (String)(OAInterfaceBusInessTypeEnum.getDescByValue(businessType) + "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u300b\u300b\u300b" + result.getString("message") + "\u3010\u8bf7\u8054\u7cfb" + OAInterfaceBusInessTypeEnum.getSourceSystemByValue(businessType) + "\u7ba1\u7406\u5458!!!\u3011"));
        try {
            JSONObject object = result.getJSONObject("result");
            String oaId = result.getJSONObject("result").getString("return");
            oaInterfaceResultDTO.setTotalResult(object);
            oaInterfaceResultDTO.setResult(oaId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ELSBootException(OAInterfaceBusInessTypeEnum.getDescByValue(businessType) + "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u300b\u300b\u300b" + result.getString("result") + "\u3010\u8bf7\u8054\u7cfb" + OAInterfaceBusInessTypeEnum.getSourceSystemByValue(businessType) + "\u7ba1\u7406\u5458!!!\u3011");
        }
        return oaInterfaceResultDTO;
    }
}

