/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.service.SqlRunnerRpcService;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.Assert;
import com.els.common.util.DateUtils;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.extend.api.enumerate.GipParamEnum;
import com.els.modules.extend.api.enumerate.InterfaceCodeEnum;
import com.els.modules.extend.api.vo.OaSendTodoDoneVO;
import com.els.modules.extend.api.vo.OaSendTodoVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SrmInterfaceUtil {
    private static final Logger log = LoggerFactory.getLogger(SrmInterfaceUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(SrmInterfaceUtil.class);
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Resource
    private TaskService taskService;
    @Autowired
    private SqlRunnerRpcService sqlRunnerRpcService;
    private static String INTERFACE_PLATFORM_KEY = "sys:thirdAuth:interfaceToken:";
    private static String INTERFACE_PLATFORM_URL = "/els/openApi/invoke";

    public String call(InterfaceCodeEnum interfaceCodeEnum, Object obj) {
        JSONObject param = new JSONObject();
        String elsAccount = this.purchaseAccount;
        param.put("body", obj);
        param.put("bus_account", (Object)TenantContext.getTenant());
        param.put("srm_interface_code", (Object)interfaceCodeEnum.getValue());
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)param));
        JSONObject result = this.interfaceUtil.callInterface("1664299", "", param, (Object)"");
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8fd4\u56de\u63a5\u53e3\uff1a" + JSONObject.toJSONString((Object)result));
        Boolean success = result.getBoolean("success");
        if (null == success || !success.booleanValue()) {
            throw new ELSBootException("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u62a5\u9519\uff0c\u3010\u8bf7\u8054\u7cfbOA\u7cfb\u7edf\u7ba1\u7406\u5458\u3011\uff01\uff01\uff01\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u4e3a\u300b=" + JSONObject.toJSONString((Object)result));
        }
        String interfaceResult = result.getString("result");
        if (null == interfaceResult || StringUtils.isBlank((CharSequence)interfaceResult)) {
            throw new ELSBootException("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u62a5\u9519\uff0c\u3010\u8bf7\u8054\u7cfbOA\u7cfb\u7edf\u7ba1\u7406\u5458\u3011\uff01\uff01\uff01\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u4e3a\u300b=" + JSONObject.toJSONString((Object)result));
        }
        return interfaceResult;
    }

    public Result<?> oaSendTodo(GipParamEnum paramEnum, String businessId, String creatorId, String targetId, String json, String processRootId, String auditStatus, String step) {
        logger.info("\u5ba1\u6279\u5f85\u529e\u5165\u53c2\uff1a" + (Object)((Object)paramEnum) + " " + businessId + " " + creatorId + " " + targetId + " " + processRootId);
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processRootId)).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            throw new ELSBootException("\u6570\u636e\u5f02\u5e38\uff0c\u5f53\u524d\u5ba1\u6279\u4e0d\u5b58\u5728\u5bf9\u5e94task");
        }
        Task task = (Task)taskList.get(0);
        if (task == null) {
            throw new ELSBootException("\u6570\u636e\u5f02\u5e38\uff0c\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u5217\u8868\u7684\u7b2c\u4e00\u4e2a\u4efb\u52a1\u4e3anull");
        }
        String modelId = task.getId();
        String nodeRunId = task.getId();
        log.info("Fetching pre_node_id and status for nodeRunId: " + nodeRunId);
        JSONObject preNodeIdAndStatus = this.queryPreNodeIdAndStatus(nodeRunId);
        if (preNodeIdAndStatus != null) {
            String preNodeId = preNodeIdAndStatus.getString("pre_node_id");
            String status = preNodeIdAndStatus.getString("status");
            if (StringUtils.isNotBlank((CharSequence)preNodeId) && StringUtils.isBlank((CharSequence)status) && "startCallBack".equals(step)) {
                log.info("Status is null or empty, checking status for preNodeId: " + preNodeId + ", step: " + step);
                String firstStepStatus = this.queryStatusByNodeId(preNodeId);
                if ("skip".equals(firstStepStatus)) {
                    modelId = preNodeId;
                }
            }
        } else {
            log.warn("No pre_node_id found for nodeRunId: " + nodeRunId);
        }
        ElsSubAccountDTO submiterDto = null;
        submiterDto = creatorId.split("_").length == 2 ? this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), creatorId.split("_")[1]) : this.invokeAccountRpcService.getAccountById(creatorId);
        ElsSubAccountDTO targetsDto = this.invokeAccountRpcService.getAccountById(targetId);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String needdEncode = "?taskId=" + jsonObject.get((Object)"taskId") + "&businessType=" + jsonObject.get((Object)"businessType") + "&businessId=" + jsonObject.get((Object)"businessId") + "&processInstanceId=" + jsonObject.get((Object)"rootProcessInstanceId");
        String encodeStr = URLUtil.encodeAll((String)needdEncode);
        String param = paramEnum.geLink() + encodeStr;
        String link = "/jlb/jlb_address_change/srmSsoAction.do?method=send&amp;redirectUrl=" + paramEnum.geLink() + processRootId;
        Assert.isNotNull((Object)submiterDto, (String)"\u63d0\u4ea4\u4eba\u4e0d\u5b58\u5728\uff01");
        Assert.isNotNull((Object)targetsDto, (String)"\u5ba1\u6279\u4eba\u4e0d\u5b58\u5728\uff01");
        OaSendTodoVO oaSendTodoVO = new OaSendTodoVO();
        JSONObject docCreator = new JSONObject();
        JSONObject targets = new JSONObject();
        docCreator.put("PersonNo", (Object)submiterDto.getWorkNo());
        targets.put("PersonNo", (Object)targetsDto.getWorkNo());
        oaSendTodoVO.setAppName("SRM");
        oaSendTodoVO.setCreateTime(DateUtils.date2Str((Date)DateUtils.getDate(), (SimpleDateFormat)((SimpleDateFormat)DateUtils.getDatetimeFormat().get())));
        oaSendTodoVO.setLevel(paramEnum.getlevel());
        oaSendTodoVO.setModelId(modelId);
        oaSendTodoVO.setModelName(paramEnum.getModelName());
        oaSendTodoVO.setSubject("\u8bf7\u5ba1\u6279" + submiterDto.getRealname() + "\u63d0\u4ea4\u7684\u6d41\u7a0b:" + paramEnum.getBizName());
        oaSendTodoVO.setType(paramEnum.getType());
        oaSendTodoVO.setDocCreator(docCreator.toJSONString());
        oaSendTodoVO.setTargets(targets.toJSONString());
        oaSendTodoVO.setLink(link);
        Result finalResult = new Result();
        JSONObject body = new JSONObject();
        body.put("arg0", (Object)oaSendTodoVO);
        try {
            String result = this.call(InterfaceCodeEnum.OA_SEND_TODO, body);
            if (ObjectUtils.isEmpty((Object)result)) {
                return Result.error((String)"\u63a8\u9001OA\u5f85\u529e\u5931\u8d25");
            }
            JSONObject resultObj = JSONObject.parseObject((String)result.toString());
            finalResult.setResult((Object)resultObj);
            finalResult.setSuccess(true);
            return finalResult;
        }
        catch (ELSBootException e) {
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u5931\u8d25 \u63a5\u53e3\u7f16\u7801\u3010" + InterfaceCodeEnum.OA_SEND_TODO.getValue() + InterfaceCodeEnum.OA_SEND_TODO.getDesc() + "\u3011");
            return Result.error((String)"\u63a8\u9001OA\u5f85\u529e\u5931\u8d25");
        }
    }

    public Result<?> oaSendTodoDone(GipParamEnum paramEnum, String modelId, String targetId) {
        JSONObject firstObject;
        logger.info("\u5ba1\u6279\u5df2\u529e\u5165\u53c2\uff1a" + (Object)((Object)paramEnum) + " " + modelId + " " + targetId);
        ElsSubAccountDTO targetsDto = this.invokeAccountRpcService.getAccountById(targetId);
        Assert.isNotNull((Object)targetsDto, (String)"\u5904\u7406\u4eba\u4e0d\u5b58\u5728");
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(modelId)).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25,\u4e0d\u5b58\u5728\u5f85\u529e\u6d88\u606f");
        }
        Task task = (Task)taskList.get(0);
        if (task == null) {
            return Result.error((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u5217\u8868\u7684\u7b2c\u4e00\u4e2a\u4efb\u52a1\u4e3anull");
        }
        String nodeRunId = ((Task)taskList.get(0)).getId();
        String sql = "SELECT pre_node_id FROM A1_FLOW_TASK_TRAJECTORY WHERE NODE_RUN_ID = '" + nodeRunId + "'";
        String jsonString = this.sqlRunnerRpcService.runSql(sql, null);
        JSONArray sqlJsonArray = JSON.parseArray((String)jsonString);
        String preNodeId = null;
        if (CollectionUtil.isNotEmpty((Collection)sqlJsonArray)) {
            firstObject = sqlJsonArray.getJSONObject(0);
            if (firstObject == null || !firstObject.containsKey((Object)"pre_node_id")) {
                return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25\uff0cpre_node_id \u4e0d\u5b58\u5728");
            }
        } else {
            return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25, \u4e0d\u5b58\u5728\u5f85\u529e\u6d88\u606f");
        }
        preNodeId = firstObject.getString("pre_node_id");
        if (preNodeId == null || preNodeId.isEmpty()) {
            return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25");
        }
        OaSendTodoDoneVO oaSendTodoDoneVO = new OaSendTodoDoneVO();
        JSONArray jsonArray = new JSONArray();
        JSONObject targets = new JSONObject();
        targets.put("PersonNo", (Object)targetsDto.getWorkNo());
        jsonArray.add((Object)targets);
        oaSendTodoDoneVO.setAppName("SRM");
        oaSendTodoDoneVO.setOptType(1);
        oaSendTodoDoneVO.setModelId(preNodeId);
        oaSendTodoDoneVO.setModelName(paramEnum.getModelName());
        oaSendTodoDoneVO.setTargets(jsonArray.toJSONString());
        Result finalResult = new Result();
        JSONObject body = new JSONObject();
        body.put("arg0", (Object)oaSendTodoDoneVO);
        try {
            String result = this.call(InterfaceCodeEnum.OA_SET_TODO_DONE, body);
            if (ObjectUtils.isEmpty((Object)result)) {
                return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25");
            }
            JSONObject resultObj = JSONObject.parseObject((String)result.toString());
            finalResult.setResult((Object)resultObj);
            finalResult.setSuccess(true);
            return finalResult;
        }
        catch (ELSBootException e) {
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u5931\u8d25 \u63a5\u53e3\u7f16\u7801\u3010" + InterfaceCodeEnum.OA_SET_TODO_DONE.getValue() + InterfaceCodeEnum.OA_SET_TODO_DONE.getDesc() + "\u3011");
            return Result.error((String)"\u63a8\u9001OA\u5df2\u529e\u5931\u8d25");
        }
    }

    public static String getOutUrl(ElsSubAccountDTO account, String redirectUri) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append(redirectUri);
        return url.toString();
    }

    private JSONObject queryPreNodeIdAndStatus(String nodeRunId) {
        String sql = "SELECT pre_node_id, status FROM A1_FLOW_TASK_TRAJECTORY WHERE NODE_RUN_ID = '" + nodeRunId + "'";
        String jsonString = this.sqlRunnerRpcService.runSql(sql, null);
        JSONArray sqlJsonArray = JSON.parseArray((String)jsonString);
        if (CollectionUtil.isNotEmpty((Collection)sqlJsonArray)) {
            JSONObject firstObject = sqlJsonArray.getJSONObject(0);
            return firstObject;
        }
        return null;
    }

    private String queryStatusByNodeId(String nodeRunId) {
        String sql = "SELECT status FROM A1_FLOW_TASK_TRAJECTORY WHERE NODE_RUN_ID = '" + nodeRunId + "'";
        String jsonString = this.sqlRunnerRpcService.runSql(sql, null);
        JSONArray sqlJsonArray = JSON.parseArray((String)jsonString);
        if (CollectionUtil.isNotEmpty((Collection)sqlJsonArray)) {
            JSONObject firstObject = sqlJsonArray.getJSONObject(0);
            return firstObject.getString("status");
        }
        return null;
    }
}

