/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.AggCorrector;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import com.tencent.supersonic.headless.chat.corrector.GroupByCorrector;
import com.tencent.supersonic.headless.chat.corrector.HavingCorrector;
import com.tencent.supersonic.headless.chat.corrector.SelectCorrector;
import com.tencent.supersonic.headless.chat.corrector.WhereCorrector;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrammarCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(GrammarCorrector.class);
    private List<BaseSemanticCorrector> correctors = new ArrayList<BaseSemanticCorrector>();

    public GrammarCorrector() {
        this.correctors.add(new SelectCorrector());
        this.correctors.add(new WhereCorrector());
        this.correctors.add(new GroupByCorrector());
        this.correctors.add(new AggCorrector());
        this.correctors.add(new HavingCorrector());
    }

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        for (BaseSemanticCorrector corrector : this.correctors) {
            corrector.correct(chatQueryContext, semanticParseInfo);
        }
        this.removeSameFieldFromSelect(semanticParseInfo);
    }

    public void removeSameFieldFromSelect(SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        correctS2SQL = SqlRemoveHelper.removeSameFieldFromSelect((String)correctS2SQL);
        semanticParseInfo.getSqlInfo().setCorrectS2SQL(correctS2SQL);
    }
}

