/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.SqlInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class GroupByCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(GroupByCorrector.class);

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Boolean needAddGroupBy = this.needAddGroupBy(chatQueryContext, semanticParseInfo);
        if (!needAddGroupBy.booleanValue()) {
            return;
        }
        this.addGroupByFields(chatQueryContext, semanticParseInfo);
    }

    private Boolean needAddGroupBy(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Long dataSetId = semanticParseInfo.getDataSetId();
        SqlInfo sqlInfo = semanticParseInfo.getSqlInfo();
        String correctS2SQL = sqlInfo.getCorrectS2SQL();
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        if (SqlSelectHelper.hasDistinct((String)correctS2SQL)) {
            log.debug("no need to add groupby ,existed distinct in s2sql:{}", (Object)correctS2SQL);
            return false;
        }
        Set<String> dimensions = this.getDimensions(dataSetId, semanticSchema);
        List selectFields = SqlSelectHelper.getSelectFields((String)correctS2SQL);
        if (CollectionUtils.isEmpty((Collection)selectFields) || CollectionUtils.isEmpty(dimensions)) {
            return false;
        }
        if (selectFields.size() == 1 && selectFields.contains(TimeDimensionEnum.DAY.getChName())) {
            return false;
        }
        if (SqlSelectHelper.hasGroupBy((String)correctS2SQL)) {
            log.debug("No need to add groupby, existed groupby in s2sql:{}", (Object)correctS2SQL);
            return false;
        }
        Environment environment = (Environment)ContextUtils.getBean(Environment.class);
        String correctorAdditionalInfo = environment.getProperty("s2.corrector.additional.information");
        if (StringUtils.isNotBlank((CharSequence)correctorAdditionalInfo) && !Boolean.parseBoolean(correctorAdditionalInfo)) {
            return false;
        }
        return true;
    }

    private void addGroupByFields(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Long dataSetId = semanticParseInfo.getDataSetId();
        SqlInfo sqlInfo = semanticParseInfo.getSqlInfo();
        String correctS2SQL = sqlInfo.getCorrectS2SQL();
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        Set<String> dimensions = this.getDimensions(dataSetId, semanticSchema);
        List selectFields = SqlSelectHelper.getSelectFields((String)correctS2SQL);
        List aggregateFields = SqlSelectHelper.getAggregateFields((String)correctS2SQL);
        Set groupByFields = selectFields.stream().filter(field -> dimensions.contains(field)).filter(field -> CollectionUtils.isEmpty((Collection)aggregateFields) || !aggregateFields.contains(field)).collect(Collectors.toSet());
        semanticParseInfo.getSqlInfo().setCorrectS2SQL(SqlAddHelper.addGroupBy((String)correctS2SQL, groupByFields));
    }
}

