/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class HavingCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(HavingCorrector.class);

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        this.addHaving(chatQueryContext, semanticParseInfo);
        Environment environment = (Environment)ContextUtils.getBean(Environment.class);
        String correctorAdditionalInfo = environment.getProperty("s2.corrector.additional.information");
        if (StringUtils.isNotBlank((CharSequence)correctorAdditionalInfo) && Boolean.parseBoolean(correctorAdditionalInfo)) {
            this.addHavingToSelect(semanticParseInfo);
        }
    }

    private void addHaving(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Long dataSet = semanticParseInfo.getDataSet().getDataSet();
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        Set metrics = semanticSchema.getMetrics(dataSet).stream().map(schemaElement -> schemaElement.getName()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(metrics)) {
            return;
        }
        String havingSql = SqlAddHelper.addHaving((String)semanticParseInfo.getSqlInfo().getCorrectS2SQL(), metrics);
        semanticParseInfo.getSqlInfo().setCorrectS2SQL(havingSql);
    }

    private void addHavingToSelect(SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        if (!SqlSelectFunctionHelper.hasAggregateFunction((String)correctS2SQL)) {
            return;
        }
        List havingExpressionList = SqlSelectHelper.getHavingExpression((String)correctS2SQL);
        if (!CollectionUtils.isEmpty((Collection)havingExpressionList)) {
            String replaceSql = SqlAddHelper.addFunctionToSelect((String)correctS2SQL, (List)havingExpressionList);
            semanticParseInfo.getSqlInfo().setCorrectS2SQL(replaceSql);
        }
    }
}

