/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.DateVisitor;
import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlDateSelectHelper;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import com.tencent.supersonic.headless.chat.corrector.S2SqlDateHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class TimeCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(TimeCorrector.class);

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        this.addDateIfNotExist(chatQueryContext, semanticParseInfo);
        this.removeDateIfExist(chatQueryContext, semanticParseInfo);
        this.parserDateDiffFunction(semanticParseInfo);
        this.addLowerBoundDate(semanticParseInfo);
    }

    private void removeDateIfExist(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        Environment environment = (Environment)ContextUtils.getBean(Environment.class);
        String correctorDate = environment.getProperty("s2.corrector.date");
        if (StringUtils.isNotBlank((CharSequence)correctorDate) && !Boolean.parseBoolean(correctorDate)) {
            HashSet<String> removeFieldNames = new HashSet<String>();
            removeFieldNames.add(TimeDimensionEnum.DAY.getChName());
            removeFieldNames.add(TimeDimensionEnum.WEEK.getChName());
            removeFieldNames.add(TimeDimensionEnum.MONTH.getChName());
            correctS2SQL = SqlRemoveHelper.removeWhereCondition((String)correctS2SQL, removeFieldNames);
            semanticParseInfo.getSqlInfo().setCorrectS2SQL(correctS2SQL);
        }
    }

    private void addDateIfNotExist(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Pair<String, String> startEndDate;
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        List whereFields = SqlSelectHelper.getWhereFields((String)correctS2SQL);
        Environment environment = (Environment)ContextUtils.getBean(Environment.class);
        String correctorDate = environment.getProperty("s2.corrector.date");
        if (StringUtils.isNotBlank((CharSequence)correctorDate) && !Boolean.parseBoolean(correctorDate)) {
            return;
        }
        if ((CollectionUtils.isEmpty((Collection)whereFields) || !TimeDimensionEnum.containsZhTimeDimension((List)whereFields)) && StringUtils.isNotBlank((CharSequence)((CharSequence)(startEndDate = S2SqlDateHelper.getStartEndDate(chatQueryContext, semanticParseInfo.getDataSetId(), semanticParseInfo.getQueryType())).getLeft())) && StringUtils.isNotBlank((CharSequence)((CharSequence)startEndDate.getRight()))) {
            correctS2SQL = SqlAddHelper.addParenthesisToWhere((String)correctS2SQL);
            String dateChName = TimeDimensionEnum.DAY.getChName();
            String condExpr = String.format(" ( %s >= '%s'  and %s <= '%s' )", dateChName, startEndDate.getLeft(), dateChName, startEndDate.getRight());
            try {
                Expression expression = CCJSqlParserUtil.parseCondExpression((String)condExpr);
                correctS2SQL = SqlAddHelper.addWhere((String)correctS2SQL, (Expression)expression);
            }
            catch (JSQLParserException e) {
                log.error("parseCondExpression:{}", (Throwable)e);
            }
        }
        semanticParseInfo.getSqlInfo().setCorrectS2SQL(correctS2SQL);
    }

    private void addLowerBoundDate(SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        DateVisitor.DateBoundInfo dateBoundInfo = SqlDateSelectHelper.getDateBoundInfo((String)correctS2SQL);
        if (Objects.isNull(dateBoundInfo)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dateBoundInfo.getLowerBound()) && StringUtils.isNotBlank((CharSequence)dateBoundInfo.getUpperBound()) && StringUtils.isNotBlank((CharSequence)dateBoundInfo.getUpperDate())) {
            String upperDate = dateBoundInfo.getUpperDate();
            try {
                correctS2SQL = SqlAddHelper.addParenthesisToWhere((String)correctS2SQL);
                String condExpr = dateBoundInfo.getColumName() + " >= '" + upperDate + "'";
                correctS2SQL = SqlAddHelper.addWhere((String)correctS2SQL, (Expression)CCJSqlParserUtil.parseCondExpression((String)condExpr));
            }
            catch (JSQLParserException e) {
                log.error("parseCondExpression", (Throwable)e);
            }
            semanticParseInfo.getSqlInfo().setCorrectS2SQL(correctS2SQL);
        }
    }

    private void parserDateDiffFunction(SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectS2SQL();
        correctS2SQL = SqlReplaceHelper.replaceFunction((String)correctS2SQL);
        semanticParseInfo.getSqlInfo().setCorrectS2SQL(correctS2SQL);
    }
}

