/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge;

import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.service.EmbeddingService;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import dev.langchain4j.store.embedding.Retrieval;
import dev.langchain4j.store.embedding.RetrieveQuery;
import dev.langchain4j.store.embedding.RetrieveQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaEmbeddingService {
    private static final Logger log = LoggerFactory.getLogger(MetaEmbeddingService.class);
    @Autowired
    private EmbeddingService embeddingService;
    @Autowired
    private EmbeddingConfig embeddingConfig;

    public List<RetrieveQueryResult> retrieveQuery(RetrieveQuery retrieveQuery, int num, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        String collectionName;
        List resultList;
        Set<Long> allModels = NatureHelper.getModelIds(modelIdToDataSetIds, detectDataSetIds);
        if (CollectionUtils.isNotEmpty(allModels) && allModels.size() == 1) {
            HashMap<String, String> filterCondition = new HashMap<String, String>();
            filterCondition.put("modelId", ((Long)allModels.stream().findFirst().get()).toString());
            retrieveQuery.setFilterCondition(filterCondition);
        }
        if (CollectionUtils.isEmpty((Collection)(resultList = this.embeddingService.retrieveQuery(collectionName = this.embeddingConfig.getMetaCollectionName(), retrieveQuery, num)))) {
            return new ArrayList<RetrieveQueryResult>();
        }
        if (CollectionUtils.isEmpty(allModels)) {
            return resultList;
        }
        return resultList.stream().map(retrieveQueryResult -> {
            List retrievals = retrieveQueryResult.getRetrieval();
            if (CollectionUtils.isEmpty((Collection)retrievals)) {
                return retrieveQueryResult;
            }
            retrievals.removeIf(retrieval -> {
                Long modelId = Retrieval.getLongId(retrieval.getMetadata().get("modelId"));
                if (Objects.isNull(modelId)) {
                    return CollectionUtils.isEmpty((Collection)allModels);
                }
                return !allModels.contains(modelId);
            });
            retrievals = retrievals.stream().flatMap(retrieval -> {
                Long modelId = Retrieval.getLongId(retrieval.getMetadata().get("modelId"));
                List dataSetIdsByModelId = (List)modelIdToDataSetIds.get(modelId);
                if (!CollectionUtils.isEmpty((Collection)dataSetIdsByModelId)) {
                    HashSet<Retrieval> result = new HashSet<Retrieval>();
                    for (Long dataSetId : dataSetIdsByModelId) {
                        Retrieval retrievalNew = new Retrieval();
                        BeanUtils.copyProperties((Object)retrieval, (Object)retrievalNew);
                        retrievalNew.getMetadata().putIfAbsent("dataSetId", dataSetId + "_");
                        result.add(retrievalNew);
                    }
                    return result.stream();
                }
                HashSet<Retrieval> result = new HashSet<Retrieval>();
                result.add((Retrieval)retrieval);
                return result.stream();
            }).collect(Collectors.toList());
            retrieveQueryResult.setRetrieval(retrievals);
            return retrieveQueryResult;
        }).filter(retrieveQueryResult -> CollectionUtils.isNotEmpty((Collection)retrieveQueryResult.getRetrieval())).collect(Collectors.toList());
    }
}

