/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge;

import com.hankcs.hanlp.collection.trie.bintrie.BaseNode;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.DictionaryAttributeUtil;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.MultiCustomDictionary;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchService.class);
    public static final int SEARCH_SIZE = 200;
    private static BinTrie<List<String>> trie = new BinTrie();
    private static BinTrie<List<String>> suffixTrie = new BinTrie();

    public static List<HanlpMapResult> prefixSearch(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        return SearchService.prefixSearch(key, limit, trie, modelIdToDataSetIds, detectDataSetIds);
    }

    public static List<HanlpMapResult> prefixSearch(String key, int limit, BinTrie<List<String>> binTrie, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        Set<Map.Entry<String, List<String>>> result = SearchService.search(key, binTrie);
        List<HanlpMapResult> hanlpMapResults = result.stream().map(entry -> {
            String name = ((String)entry.getKey()).replace("#", " ");
            return new HanlpMapResult(name, (List)entry.getValue(), key);
        }).sorted((a, b) -> -(b.getName().length() - a.getName().length())).collect(Collectors.toList());
        hanlpMapResults = SearchService.transformAndFilterByDataSet(hanlpMapResults, modelIdToDataSetIds, detectDataSetIds, limit);
        return hanlpMapResults;
    }

    public static List<HanlpMapResult> suffixSearch(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        String reverseDetectSegment = StringUtils.reverse((String)key);
        return SearchService.suffixSearch(reverseDetectSegment, limit, suffixTrie, modelIdToDataSetIds, detectDataSetIds);
    }

    public static List<HanlpMapResult> suffixSearch(String key, int limit, BinTrie<List<String>> binTrie, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        Set<Map.Entry<String, List<String>>> result = SearchService.search(key, binTrie);
        List<HanlpMapResult> hanlpMapResults = result.stream().map(entry -> {
            String name = ((String)entry.getKey()).replace("#", " ");
            List<String> natures = ((List)entry.getValue()).stream().map(nature -> nature.replaceAll(DictWordType.SUFFIX.getType(), "")).collect(Collectors.toList());
            name = StringUtils.reverse((String)name);
            return new HanlpMapResult(name, natures, key);
        }).sorted((a, b) -> -(b.getName().length() - a.getName().length())).collect(Collectors.toList());
        return SearchService.transformAndFilterByDataSet(hanlpMapResults, modelIdToDataSetIds, detectDataSetIds, limit);
    }

    private static List<HanlpMapResult> transformAndFilterByDataSet(List<HanlpMapResult> hanlpMapResults, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds, int limit) {
        return hanlpMapResults.stream().peek(hanlpMapResult -> {
            List<String> natures = hanlpMapResult.getNatures().stream().map(nature -> NatureHelper.changeModel2DataSet(nature, modelIdToDataSetIds)).flatMap(Collection::stream).filter(nature -> {
                if (CollectionUtils.isEmpty((Collection)detectDataSetIds)) {
                    return true;
                }
                Long dataSetId = NatureHelper.getDataSetId(nature);
                if (dataSetId != null) {
                    return detectDataSetIds.contains(dataSetId);
                }
                return false;
            }).collect(Collectors.toList());
            hanlpMapResult.setNatures(natures);
        }).filter(hanlpMapResult -> !CollectionUtils.isEmpty(hanlpMapResult.getNatures())).limit(limit).collect(Collectors.toList());
    }

    private static Set<Map.Entry<String, List<String>>> search(String key, BinTrie<List<String>> binTrie) {
        char[] chars;
        key = key.toLowerCase();
        TreeSet<Map.Entry<String, List<String>>> entrySet = new TreeSet<Map.Entry<String, List<String>>>();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            sb = new StringBuilder(key.substring(0, key.length() - 1));
        }
        BaseNode branch = binTrie;
        for (char aChar : chars = key.toCharArray()) {
            if (branch == null) {
                return entrySet;
            }
            branch = branch.getChild(aChar);
        }
        if (branch == null) {
            return entrySet;
        }
        branch.walkLimit(sb, entrySet);
        return entrySet;
    }

    public static void clear() {
        log.debug("clear all trie");
        trie = new BinTrie();
        suffixTrie = new BinTrie();
    }

    public static void put(String key, CoreDictionary.Attribute attribute) {
        trie.put(key, SearchService.getValue(attribute.nature));
    }

    public static void loadSuffix(List<DictWord> suffixes) {
        if (CollectionUtils.isEmpty(suffixes)) {
            return;
        }
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        for (DictWord dictWord : suffixes) {
            CoreDictionary.Attribute attributeNew;
            CoreDictionary.Attribute attribute = attributeNew = dictWord.getNatureWithFrequency() == null ? new CoreDictionary.Attribute(Nature.nz, 1) : CoreDictionary.Attribute.create((String)dictWord.getNatureWithFrequency());
            if (map.containsKey(dictWord.getWord())) {
                attributeNew = DictionaryAttributeUtil.getAttribute((CoreDictionary.Attribute)map.get(dictWord.getWord()), attributeNew);
            }
            map.put(dictWord.getWord(), attributeNew);
        }
        for (Map.Entry entry : map.entrySet()) {
            SearchService.putSuffix((String)entry.getKey(), (CoreDictionary.Attribute)entry.getValue());
        }
    }

    public static void putSuffix(String key, CoreDictionary.Attribute attribute) {
        Nature[] nature = attribute.nature;
        suffixTrie.put(key, SearchService.getValue(nature));
    }

    private static List<String> getValue(Nature[] nature) {
        return Arrays.stream(nature).map(entry -> entry.toString()).collect(Collectors.toList());
    }

    public static void remove(DictWord dictWord, Nature[] natures) {
        trie.remove(dictWord.getWord());
        if (Objects.nonNull(natures) && natures.length > 0) {
            trie.put(dictWord.getWord(), SearchService.getValue(natures));
        }
        if (dictWord.getNature().contains(DictWordType.METRIC.getType()) || dictWord.getNature().contains(DictWordType.DIMENSION.getType())) {
            suffixTrie.remove(dictWord.getWord());
        }
    }

    public static List<String> getDimensionValue(DimensionValueReq dimensionValueReq) {
        String nature = "_" + dimensionValueReq.getModelId() + "_" + dimensionValueReq.getElementID();
        PriorityQueue<Term> terms = MultiCustomDictionary.NATURE_TO_VALUES.get(nature);
        if (CollectionUtils.isEmpty(terms)) {
            return new ArrayList<String>();
        }
        return terms.stream().map(term -> term.getWord()).collect(Collectors.toList());
    }
}

