/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.builder;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordWithAliasBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EntityWordBuilder
extends BaseWordWithAliasBuilder {
    private static final Logger log = LoggerFactory.getLogger(EntityWordBuilder.class);

    @Override
    public List<DictWord> doGet(String word, SchemaElement schemaElement) {
        ArrayList result = Lists.newArrayList();
        if (Objects.isNull(schemaElement)) {
            return result;
        }
        result.add(this.getOneWordNature(word, schemaElement, false));
        result.addAll(this.getOneWordNatureAlias(schemaElement, false));
        return result;
    }

    @Override
    public DictWord getOneWordNature(String word, SchemaElement schemaElement, boolean isSuffix) {
        String nature = "_" + schemaElement.getModel() + "_" + schemaElement.getId() + DictWordType.ENTITY.getType();
        DictWord dictWord = new DictWord();
        dictWord.setWord(word);
        dictWord.setNatureWithFrequency(String.format("%s " + DEFAULT_FREQUENCY * 2L, nature));
        return dictWord;
    }
}

