/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.helper;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import com.tencent.supersonic.headless.chat.knowledge.helper.FileHelper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsFileHelper {
    private static final Logger log = LoggerFactory.getLogger(HdfsFileHelper.class);

    public static void deleteCacheFile(String[] path) throws IOException {
        FileSystem fs = FileSystem.get((URI)URI.create(path[0]), (Configuration)new Configuration());
        String cacheFilePath = path[0] + ".bin";
        log.info("delete cache file:{}", (Object)cacheFilePath);
        try {
            fs.delete(new Path(cacheFilePath), false);
        }
        catch (Exception e) {
            log.error("delete:" + cacheFilePath, (Throwable)e);
        }
        int customBase = cacheFilePath.lastIndexOf(FileHelper.FILE_SPILT);
        String customPath = cacheFilePath.substring(0, customBase) + FileHelper.FILE_SPILT + "*.bin";
        List<String> fileList = HdfsFileHelper.getFileList(fs, new Path(customPath));
        for (String file : fileList) {
            try {
                fs.delete(new Path(file), false);
                log.info("delete cache file:{}", (Object)file);
            }
            catch (Exception e) {
                log.error("delete " + file, (Throwable)e);
            }
        }
        log.info("fileList:{}", fileList);
    }

    public static void resetCustomPath(DynamicCustomDictionary customDictionary) throws IOException {
        String[] path = HanLP.Config.CustomDictionaryPath;
        FileSystem fs = FileSystem.get((URI)URI.create(path[0]), (Configuration)new Configuration());
        String cacheFilePath = path[0] + ".bin";
        int customBase = cacheFilePath.lastIndexOf(FileHelper.FILE_SPILT);
        String customPath = cacheFilePath.substring(0, customBase) + FileHelper.FILE_SPILT + "*.txt";
        log.info("customPath:{}", (Object)customPath);
        List<String> fileList = HdfsFileHelper.getFileList(fs, new Path(customPath));
        log.info("CustomDictionaryPath:{}", fileList);
        HanLP.Config.CustomDictionaryPath = fileList.toArray(new String[0]);
        String[] stringArray = customDictionary.path = HanLP.Config.CustomDictionaryPath == null || HanLP.Config.CustomDictionaryPath.length == 0 ? path : HanLP.Config.CustomDictionaryPath;
        if (HanLP.Config.CustomDictionaryPath == null || HanLP.Config.CustomDictionaryPath.length == 0) {
            HanLP.Config.CustomDictionaryPath = path;
        }
    }

    public static List<String> getFileList(FileSystem fs, Path folderPath) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        FileStatus[] fileStatuses = fs.globStatus(folderPath);
        for (int i = 0; i < fileStatuses.length; ++i) {
            FileStatus fileStatus = fileStatuses[i];
            paths.add(fileStatus.getPath().toString());
        }
        return paths;
    }
}

