/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.helper;

import com.google.common.collect.Lists;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.knowledge.DataSetInfoStat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NatureHelper {
    private static final Logger log = LoggerFactory.getLogger(NatureHelper.class);

    public static SchemaElementType convertToElementType(String nature) {
        DictWordType dictWordType = DictWordType.getNatureType((String)nature);
        if (Objects.isNull(dictWordType)) {
            return null;
        }
        SchemaElementType result = null;
        switch (dictWordType) {
            case METRIC: {
                result = SchemaElementType.METRIC;
                break;
            }
            case DIMENSION: {
                result = SchemaElementType.DIMENSION;
                break;
            }
            case ENTITY: {
                result = SchemaElementType.ENTITY;
                break;
            }
            case DATASET: {
                result = SchemaElementType.DATASET;
                break;
            }
            case VALUE: {
                result = SchemaElementType.VALUE;
                break;
            }
            case TERM: {
                result = SchemaElementType.TERM;
                break;
            }
        }
        return result;
    }

    private static boolean isDataSetOrEntity(S2Term term, Integer model) {
        return ("_" + model).equals(term.nature.toString()) || term.nature.toString().endsWith(DictWordType.ENTITY.getType());
    }

    public static Integer getDataSetByNature(Nature nature) {
        String[] dimensionValues;
        if (nature.startsWith("_") && StringUtils.isNumeric((CharSequence)(dimensionValues = nature.toString().split("_"))[1])) {
            return Integer.valueOf(dimensionValues[1]);
        }
        return 0;
    }

    public static Long getDataSetId(String nature) {
        try {
            String[] split = nature.split("_");
            if (split.length <= 1) {
                return null;
            }
            return Long.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private static Long getModelId(String nature) {
        try {
            String[] split = nature.split("_");
            if (split.length <= 1) {
                return null;
            }
            return Long.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private static Nature changeModel2DataSet(String nature, Long dataSetId) {
        try {
            Object[] split = nature.split("_");
            if (split.length <= 1) {
                return null;
            }
            split[1] = String.valueOf(dataSetId);
            return Nature.create((String)StringUtils.join((Object[])split, (String)"_"));
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static List<String> changeModel2DataSet(String nature, Map<Long, List<Long>> modelIdToDataSetIds) {
        if (SchemaElementType.TERM.equals((Object)NatureHelper.convertToElementType(nature))) {
            return Lists.newArrayList((Object[])new String[]{nature});
        }
        Long modelId = NatureHelper.getModelId(nature);
        List<Long> dataSetIds = modelIdToDataSetIds.get(modelId);
        if (CollectionUtils.isEmpty(dataSetIds)) {
            return Lists.newArrayList();
        }
        return dataSetIds.stream().map(dataSetId -> String.valueOf(NatureHelper.changeModel2DataSet(nature, dataSetId))).collect(Collectors.toList());
    }

    public static boolean isDimensionValueDataSetId(String nature) {
        if (StringUtils.isEmpty((CharSequence)nature)) {
            return false;
        }
        if (!nature.startsWith("_")) {
            return false;
        }
        String[] split = nature.split("_");
        if (split.length <= 1) {
            return false;
        }
        return !nature.endsWith(DictWordType.METRIC.getType()) && !nature.endsWith(DictWordType.DIMENSION.getType()) && !nature.endsWith(DictWordType.TERM.getType()) && StringUtils.isNumeric((CharSequence)split[1]);
    }

    public static boolean isTermNature(String nature) {
        if (StringUtils.isEmpty((CharSequence)nature)) {
            return false;
        }
        if (!nature.startsWith("_")) {
            return false;
        }
        String[] split = nature.split("_");
        if (split.length <= 1) {
            return false;
        }
        return nature.endsWith(DictWordType.TERM.getType());
    }

    public static DataSetInfoStat getDataSetStat(List<S2Term> terms) {
        return DataSetInfoStat.builder().dataSetCount(NatureHelper.getDataSetCount(terms)).dimensionDataSetCount(NatureHelper.getDimensionCount(terms)).metricDataSetCount(NatureHelper.getMetricCount(terms)).dimensionValueDataSetCount(NatureHelper.getDimensionValueCount(terms)).build();
    }

    private static long getDataSetCount(List<S2Term> terms) {
        return terms.stream().filter(term -> NatureHelper.isDataSetOrEntity(term, NatureHelper.getDataSetByNature(term.nature))).count();
    }

    private static long getDimensionValueCount(List<S2Term> terms) {
        return terms.stream().filter(term -> NatureHelper.isDimensionValueDataSetId(term.nature.toString())).count();
    }

    private static long getDimensionCount(List<S2Term> terms) {
        return terms.stream().filter(term -> term.nature.startsWith("_") && term.nature.toString().endsWith(DictWordType.DIMENSION.getType())).count();
    }

    private static long getMetricCount(List<S2Term> terms) {
        return terms.stream().filter(term -> term.nature.startsWith("_") && term.nature.toString().endsWith(DictWordType.METRIC.getType())).count();
    }

    public static Map<Long, Map<DictWordType, Integer>> getDataSetToNatureStat(List<S2Term> terms) {
        HashMap<Long, Map<DictWordType, Integer>> modelToNature = new HashMap<Long, Map<DictWordType, Integer>>();
        terms.stream().filter(term -> term.nature.startsWith("_")).forEach(term -> {
            DictWordType dictWordType = DictWordType.getNatureType((String)String.valueOf(term.nature));
            Long model = NatureHelper.getDataSetId(String.valueOf(term.nature));
            HashMap<DictWordType, Integer> natureTypeMap = new HashMap<DictWordType, Integer>();
            natureTypeMap.put(dictWordType, 1);
            Map original = (Map)modelToNature.get(model);
            if (Objects.isNull(original)) {
                modelToNature.put(model, natureTypeMap);
            } else {
                Integer count = (Integer)original.get(dictWordType);
                count = Objects.isNull(count) ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                original.put(dictWordType, count);
            }
        });
        return modelToNature;
    }

    public static List<Long> selectPossibleDataSets(List<S2Term> terms) {
        Map<Long, Map<DictWordType, Integer>> modelToNatureStat = NatureHelper.getDataSetToNatureStat(terms);
        Integer maxDataSetTypeSize = modelToNatureStat.entrySet().stream().max(Comparator.comparingInt(o -> ((Map)o.getValue()).size())).map(entry -> ((Map)entry.getValue()).size()).orElse(null);
        if (Objects.isNull(maxDataSetTypeSize) || maxDataSetTypeSize == 0) {
            return new ArrayList<Long>();
        }
        return modelToNatureStat.entrySet().stream().filter(entry -> ((Map)entry.getValue()).size() == maxDataSetTypeSize.intValue()).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
    }

    public static Long getElementID(String nature) {
        String[] split = nature.split("_");
        if (split.length >= 3) {
            return Long.valueOf(split[2]);
        }
        return 0L;
    }

    public static Set<Long> getModelIds(Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        Set<Long> detectModelIds = modelIdToDataSetIds.keySet();
        if (!CollectionUtils.isEmpty(detectDataSetIds)) {
            detectModelIds = modelIdToDataSetIds.entrySet().stream().filter(entry -> {
                List dataSetIds = ((List)entry.getValue()).stream().filter(detectDataSetIds::contains).collect(Collectors.toList());
                return !CollectionUtils.isEmpty(dataSetIds);
            }).map(entry -> (Long)entry.getKey()).collect(Collectors.toSet());
        }
        return detectModelIds;
    }
}

