/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.mapper.SchemaMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public abstract class BaseMapper
implements SchemaMapper {
    private static final Logger log = LoggerFactory.getLogger(BaseMapper.class);

    @Override
    public void map(ChatQueryContext chatQueryContext) {
        String simpleName = this.getClass().getSimpleName();
        long startTime = System.currentTimeMillis();
        log.debug("before {},mapInfo:{}", (Object)simpleName, (Object)chatQueryContext.getMapInfo().getDataSetElementMatches());
        try {
            this.doMap(chatQueryContext);
            this.filter(chatQueryContext);
        }
        catch (Exception e) {
            log.error("work error", (Throwable)e);
        }
        long cost = System.currentTimeMillis() - startTime;
        log.debug("after {},cost:{},mapInfo:{}", new Object[]{simpleName, cost, chatQueryContext.getMapInfo().getDataSetElementMatches()});
    }

    private void filter(ChatQueryContext chatQueryContext) {
        BaseMapper.filterByDataSetId(chatQueryContext);
        BaseMapper.filterByDetectWordLenLessThanOne(chatQueryContext);
        switch (chatQueryContext.getQueryDataType()) {
            case TAG: {
                BaseMapper.filterByQueryDataType(chatQueryContext, element -> element.getIsTag() <= 0);
                break;
            }
            case METRIC: {
                BaseMapper.filterByQueryDataType(chatQueryContext, element -> !SchemaElementType.METRIC.equals((Object)element.getType()));
                break;
            }
            case DIMENSION: {
                BaseMapper.filterByQueryDataType(chatQueryContext, element -> {
                    boolean isDimensionOrValue = SchemaElementType.DIMENSION.equals((Object)element.getType()) || SchemaElementType.VALUE.equals((Object)element.getType());
                    return !isDimensionOrValue;
                });
                break;
            }
        }
    }

    private static void filterByDataSetId(ChatQueryContext chatQueryContext) {
        Set<Long> dataSetIds = chatQueryContext.getDataSetIds();
        if (CollectionUtils.isEmpty(dataSetIds)) {
            return;
        }
        HashSet dataSetIdInMapInfo = new HashSet(chatQueryContext.getMapInfo().getDataSetElementMatches().keySet());
        for (Long dataSetId : dataSetIdInMapInfo) {
            if (dataSetIds.contains(dataSetId)) continue;
            chatQueryContext.getMapInfo().getDataSetElementMatches().remove(dataSetId);
        }
    }

    private static void filterByDetectWordLenLessThanOne(ChatQueryContext chatQueryContext) {
        Map dataSetElementMatches = chatQueryContext.getMapInfo().getDataSetElementMatches();
        for (Map.Entry entry : dataSetElementMatches.entrySet()) {
            List value = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) continue;
            value.removeIf(schemaElementMatch -> StringUtils.length((CharSequence)schemaElementMatch.getDetectWord()) <= 1);
        }
    }

    private static void filterByQueryDataType(ChatQueryContext chatQueryContext, Predicate<SchemaElement> needRemovePredicate) {
        chatQueryContext.getMapInfo().getDataSetElementMatches().values().stream().forEach(schemaElementMatches -> schemaElementMatches.removeIf(schemaElementMatch -> {
            SchemaElement element = schemaElementMatch.getElement();
            SchemaElementType type = element.getType();
            if (SchemaElementType.ENTITY.equals((Object)type) || SchemaElementType.DATASET.equals((Object)type) || SchemaElementType.ID.equals((Object)type)) {
                return false;
            }
            return needRemovePredicate.test(element);
        }));
    }

    public abstract void doMap(ChatQueryContext var1);

    public void addToSchemaMap(SchemaMapInfo schemaMap, Long dataSetId, SchemaElementMatch newElementMatch) {
        Map dataSetElementMatches = schemaMap.getDataSetElementMatches();
        List schemaElementMatches = dataSetElementMatches.putIfAbsent(dataSetId, new ArrayList());
        if (schemaElementMatches == null) {
            schemaElementMatches = (List)dataSetElementMatches.get(dataSetId);
        }
        AtomicBoolean needAddNew = new AtomicBoolean(true);
        schemaElementMatches.removeIf(existElementMatch -> {
            if (BaseMapper.isEquals(existElementMatch, newElementMatch)) {
                if (newElementMatch.getSimilarity() > existElementMatch.getSimilarity()) {
                    return true;
                }
                needAddNew.set(false);
            }
            return false;
        });
        if (needAddNew.get()) {
            schemaElementMatches.add(newElementMatch);
        }
    }

    private static boolean isEquals(SchemaElementMatch existElementMatch, SchemaElementMatch newElementMatch) {
        SchemaElement newElement;
        SchemaElement existElement = existElementMatch.getElement();
        if (!existElement.equals((Object)(newElement = newElementMatch.getElement()))) {
            return false;
        }
        if (SchemaElementType.VALUE.equals((Object)newElement.getType())) {
            return existElementMatch.getWord().equalsIgnoreCase(newElementMatch.getWord());
        }
        return true;
    }

    public SchemaElement getSchemaElement(Long dataSetId, SchemaElementType elementType, Long elementID, SemanticSchema semanticSchema) {
        SchemaElement element = new SchemaElement();
        DataSetSchema dataSetSchema = (DataSetSchema)semanticSchema.getDataSetSchemaMap().get(dataSetId);
        if (Objects.isNull(dataSetSchema)) {
            return null;
        }
        SchemaElement elementDb = dataSetSchema.getElement(elementType, elementID.longValue());
        if (Objects.isNull(elementDb)) {
            return null;
        }
        BeanUtils.copyProperties((Object)elementDb, (Object)element);
        element.setAlias(this.getAlias(elementDb));
        return element;
    }

    public List<String> getAlias(SchemaElement element) {
        if (!SchemaElementType.VALUE.equals((Object)element.getType())) {
            return element.getAlias();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)element.getAlias()) && StringUtils.isNotEmpty((CharSequence)element.getName())) {
            return element.getAlias().stream().filter((? super T aliasItem) -> aliasItem.contains(element.getName())).collect(Collectors.toList());
        }
        return element.getAlias();
    }
}

