/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.DatabaseMapResult;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import com.tencent.supersonic.headless.chat.mapper.BaseMapper;
import com.tencent.supersonic.headless.chat.mapper.DatabaseMatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.HanlpDictMatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.MapperHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class KeywordMapper
extends BaseMapper {
    private static final Logger log = LoggerFactory.getLogger(KeywordMapper.class);

    @Override
    public void doMap(ChatQueryContext chatQueryContext) {
        String queryText = chatQueryContext.getQueryText();
        List<S2Term> terms = HanlpHelper.getTerms(queryText, chatQueryContext.getModelIdToDataSetIds());
        HanlpDictMatchStrategy hanlpMatchStrategy = (HanlpDictMatchStrategy)ContextUtils.getBean(HanlpDictMatchStrategy.class);
        List<HanlpMapResult> hanlpMapResults = hanlpMatchStrategy.getMatches(chatQueryContext, terms);
        this.convertHanlpMapResultToMapInfo(hanlpMapResults, chatQueryContext, terms);
        DatabaseMatchStrategy databaseMatchStrategy = (DatabaseMatchStrategy)ContextUtils.getBean(DatabaseMatchStrategy.class);
        List<DatabaseMapResult> databaseResults = databaseMatchStrategy.getMatches(chatQueryContext, terms);
        this.convertDatabaseMapResultToMapInfo(chatQueryContext, databaseResults);
    }

    private void convertHanlpMapResultToMapInfo(List<HanlpMapResult> mapResults, ChatQueryContext chatQueryContext, List<S2Term> terms) {
        if (CollectionUtils.isEmpty(mapResults)) {
            return;
        }
        HanlpHelper.transLetterOriginal(mapResults);
        Map<String, Long> wordNatureToFrequency = terms.stream().collect(Collectors.toMap(entry -> entry.getWord() + entry.getNature(), term -> term.getFrequency(), (value1, value2) -> value2));
        for (HanlpMapResult hanlpMapResult : mapResults) {
            for (String nature : hanlpMapResult.getNatures()) {
                Long elementID;
                SchemaElement element;
                SchemaElementType elementType;
                Long dataSetId = NatureHelper.getDataSetId(nature);
                if (Objects.isNull(dataSetId) || Objects.isNull(elementType = NatureHelper.convertToElementType(nature)) || (element = this.getSchemaElement(dataSetId, elementType, elementID = NatureHelper.getElementID(nature), chatQueryContext.getSemanticSchema())) == null) continue;
                Long frequency = wordNatureToFrequency.get(hanlpMapResult.getName() + nature);
                SchemaElementMatch schemaElementMatch = SchemaElementMatch.builder().element(element).frequency(frequency).word(hanlpMapResult.getName()).similarity(hanlpMapResult.getSimilarity()).detectWord(hanlpMapResult.getDetectWord()).build();
                this.addToSchemaMap(chatQueryContext.getMapInfo(), dataSetId, schemaElementMatch);
            }
        }
    }

    private void convertDatabaseMapResultToMapInfo(ChatQueryContext chatQueryContext, List<DatabaseMapResult> mapResults) {
        MapperHelper mapperHelper = (MapperHelper)ContextUtils.getBean(MapperHelper.class);
        for (DatabaseMapResult match : mapResults) {
            SchemaElement schemaElement = match.getSchemaElement();
            Set<Long> regElementSet = this.getRegElementSet(chatQueryContext.getMapInfo(), schemaElement);
            if (regElementSet.contains(schemaElement.getId())) continue;
            SchemaElementMatch schemaElementMatch = SchemaElementMatch.builder().element(schemaElement).word(schemaElement.getName()).detectWord(match.getDetectWord()).frequency(BaseWordBuilder.DEFAULT_FREQUENCY).similarity(mapperHelper.getSimilarity(match.getDetectWord(), schemaElement.getName())).build();
            log.info("add to schema, elementMatch {}", (Object)schemaElementMatch);
            this.addToSchemaMap(chatQueryContext.getMapInfo(), schemaElement.getDataSet(), schemaElementMatch);
        }
    }

    private Set<Long> getRegElementSet(SchemaMapInfo schemaMap, SchemaElement schemaElement) {
        List elements = schemaMap.getMatchedElements(schemaElement.getDataSet());
        if (CollectionUtils.isEmpty((Collection)elements)) {
            return new HashSet<Long>();
        }
        return elements.stream().filter(elementMatch -> SchemaElementType.METRIC.equals((Object)elementMatch.getElement().getType()) || SchemaElementType.DIMENSION.equals((Object)elementMatch.getElement().getType())).map((? super T elementMatch) -> elementMatch.getElement().getId()).collect(Collectors.toSet());
    }
}

