/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.hankcs.hanlp.algorithm.EditDistance;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MapperHelper {
    private static final Logger log = LoggerFactory.getLogger(MapperHelper.class);

    public Integer getStepIndex(Map<Integer, Integer> regOffsetToLength, Integer index) {
        Integer subRegLength = regOffsetToLength.get(index);
        if (Objects.nonNull(subRegLength)) {
            index = index + subRegLength;
        } else {
            Integer n = index;
            index = index + 1;
        }
        return index;
    }

    public Integer getStepOffset(List<S2Term> termList, Integer index) {
        List offsetList = termList.stream().sorted(Comparator.comparing(S2Term::getOffset)).map(term -> term.getOffset()).collect(Collectors.toList());
        for (int j = 0; j < termList.size() - 1; ++j) {
            if ((Integer)offsetList.get(j) > index || (Integer)offsetList.get(j + 1) <= index) continue;
            return (Integer)offsetList.get(j);
        }
        return index;
    }

    public boolean existDimensionValues(List<String> natures) {
        for (String nature : natures) {
            if (!NatureHelper.isDimensionValueDataSetId(nature)) continue;
            return true;
        }
        return false;
    }

    public boolean existTerms(List<String> natures) {
        for (String nature : natures) {
            if (!NatureHelper.isTermNature(nature)) continue;
            return true;
        }
        return false;
    }

    public double getSimilarity(String detectSegment, String matchName) {
        String detectSegmentLower = detectSegment == null ? null : detectSegment.toLowerCase();
        String matchNameLower = matchName == null ? null : matchName.toLowerCase();
        return 1.0 - (double)EditDistance.compute((String)detectSegmentLower, (String)matchNameLower) / (double)Math.max(matchName.length(), detectSegment.length());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapperHelper)) {
            return false;
        }
        MapperHelper other = (MapperHelper)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapperHelper;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MapperHelper()";
    }
}

