/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.mapper.BaseMatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.MatchText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchMatchStrategy
extends BaseMatchStrategy<HanlpMapResult> {
    private static final int SEARCH_SIZE = 3;
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;

    @Override
    public Map<MatchText, List<HanlpMapResult>> match(ChatQueryContext chatQueryContext, List<S2Term> originals, Set<Long> detectDataSetIds) {
        String text = chatQueryContext.getQueryText();
        Map<Integer, Integer> regOffsetToLength = this.getRegOffsetToLength(originals);
        ArrayList detectIndexList = Lists.newArrayList();
        Integer index = 0;
        while (index < text.length()) {
            Integer regLength;
            if (index < text.length()) {
                detectIndexList.add(index);
            }
            if (Objects.nonNull(regLength = regOffsetToLength.get(index))) {
                index = index + regLength;
                continue;
            }
            Integer n = index;
            index = index + 1;
        }
        ConcurrentHashMap<MatchText, List<HanlpMapResult>> regTextMap = new ConcurrentHashMap<MatchText, List<HanlpMapResult>>();
        ((Stream)detectIndexList.stream().parallel()).forEach(detectIndex -> {
            String regText = text.substring(0, (int)detectIndex);
            String detectSegment = text.substring((int)detectIndex);
            if (StringUtils.isNotEmpty((CharSequence)detectSegment)) {
                List<HanlpMapResult> hanlpMapResults = this.knowledgeBaseService.prefixSearch(detectSegment, 200, chatQueryContext.getModelIdToDataSetIds(), detectDataSetIds);
                List<HanlpMapResult> suffixHanlpMapResults = this.knowledgeBaseService.suffixSearch(detectSegment, 3, chatQueryContext.getModelIdToDataSetIds(), detectDataSetIds);
                hanlpMapResults.addAll(suffixHanlpMapResults);
                hanlpMapResults = hanlpMapResults.stream().filter(entry -> {
                    List natures = entry.getNatures().stream().filter(nature -> !nature.endsWith(DictWordType.ENTITY.getType())).collect(Collectors.toList());
                    return !CollectionUtils.isEmpty(natures);
                }).collect(Collectors.toList());
                MatchText matchText = MatchText.builder().regText(regText).detectSegment(detectSegment).build();
                regTextMap.put(matchText, hanlpMapResults);
            }
        });
        return regTextMap;
    }

    @Override
    public boolean needDelete(HanlpMapResult oneRoundResult, HanlpMapResult existResult) {
        return false;
    }

    @Override
    public String getMapKey(HanlpMapResult a) {
        return null;
    }

    @Override
    public void detectByStep(ChatQueryContext chatQueryContext, Set<HanlpMapResult> existResults, Set<Long> detectDataSetIds, String detectSegment, int offset) {
    }
}

