/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.ParserConfig;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatisfactionChecker {
    private static final Logger log = LoggerFactory.getLogger(SatisfactionChecker.class);

    public static boolean isSkip(ChatQueryContext chatQueryContext) {
        for (SemanticQuery query : chatQueryContext.getCandidateQueries()) {
            if (query.getQueryMode().equals("LLM_S2SQL") || !SatisfactionChecker.checkThreshold(chatQueryContext.getQueryText(), query.getParseInfo())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkThreshold(String queryText, SemanticParseInfo semanticParseInfo) {
        int queryTextLength = queryText.replaceAll(" ", "").length();
        double degree = semanticParseInfo.getScore() / (double)queryTextLength;
        ParserConfig parserConfig = (ParserConfig)((Object)ContextUtils.getBean(ParserConfig.class));
        int textLengthThreshold = Integer.valueOf(parserConfig.getParameterValue(ParserConfig.PARSER_TEXT_LENGTH_THRESHOLD));
        double longTextLengthThreshold = Double.valueOf(parserConfig.getParameterValue(ParserConfig.PARSER_TEXT_LENGTH_THRESHOLD_LONG));
        double shortTextLengthThreshold = Double.valueOf(parserConfig.getParameterValue(ParserConfig.PARSER_TEXT_LENGTH_THRESHOLD_SHORT));
        if (queryTextLength > textLengthThreshold ? degree < longTextLengthThreshold : degree < shortTextLengthThreshold) {
            return false;
        }
        log.info("queryMode:{}, degree:{}, parse info:{}", new Object[]{semanticParseInfo.getQueryMode(), degree, semanticParseInfo});
        return true;
    }
}

