/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.llm;

import com.tencent.supersonic.common.jsqlparser.SqlValidHelper;
import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.llm.ParseResult;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.llm.LLMSemanticQuery;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMResp;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMSqlResp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LLMResponseService {
    private static final Logger log = LoggerFactory.getLogger(LLMResponseService.class);

    public SemanticParseInfo addParseInfo(ChatQueryContext queryCtx, ParseResult parseResult, String s2SQL, Double weight) {
        if (Objects.isNull(weight)) {
            weight = 0.0;
        }
        LLMSemanticQuery semanticQuery = QueryManager.createLLMQuery("LLM_S2SQL");
        SemanticParseInfo parseInfo = semanticQuery.getParseInfo();
        parseInfo.setDataSet(queryCtx.getSemanticSchema().getDataSet(parseResult.getDataSetId()));
        parseInfo.getElementMatches().addAll(queryCtx.getMapInfo().getMatchedElements(parseInfo.getDataSetId()));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CONTEXT", parseResult);
        properties.put("type", "internal");
        parseInfo.setProperties(properties);
        parseInfo.setScore((double)queryCtx.getQueryText().length() * (1.0 + weight));
        parseInfo.setQueryMode(semanticQuery.getQueryMode());
        parseInfo.getSqlInfo().setS2SQL(s2SQL);
        queryCtx.getCandidateQueries().add(semanticQuery);
        return parseInfo;
    }

    public Map<String, LLMSqlResp> getDeduplicationSqlResp(int currentRetry, LLMResp llmResp) {
        Map<String, LLMSqlResp> sqlRespMap = llmResp.getSqlRespMap();
        if (MapUtils.isEmpty(sqlRespMap)) {
            LLMSqlResp llmSqlResp = new LLMSqlResp(1.0, new ArrayList<SqlExemplar>());
            sqlRespMap.put(llmResp.getSqlOutput(), llmSqlResp);
        }
        HashMap<String, LLMSqlResp> result = new HashMap<String, LLMSqlResp>();
        for (Map.Entry<String, LLMSqlResp> entry : sqlRespMap.entrySet()) {
            String key = entry.getKey();
            if (result.keySet().stream().anyMatch(existKey -> SqlValidHelper.equals((String)existKey, (String)key))) continue;
            if (!SqlValidHelper.isValidSQL((String)key)) {
                log.error("currentRetry:{},sql is not valid:{}", (Object)currentRetry, (Object)key);
                continue;
            }
            result.put(key, entry.getValue());
        }
        return result;
    }
}

