/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.llm;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.parser.llm.LLMParserConfig;
import com.tencent.supersonic.headless.chat.parser.llm.LLMRequestService;
import com.tencent.supersonic.headless.chat.parser.llm.LLMResponseService;
import com.tencent.supersonic.headless.chat.parser.llm.ParseResult;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMReq;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMResp;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMSqlResp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMSqlParser
implements SemanticParser {
    private static final Logger log = LoggerFactory.getLogger(LLMSqlParser.class);

    @Override
    public void parse(ChatQueryContext queryCtx, ChatContext chatCtx) {
        try {
            LLMRequestService requestService = (LLMRequestService)ContextUtils.getBean(LLMRequestService.class);
            if (requestService.isSkip(queryCtx)) {
                return;
            }
            Long dataSetId = requestService.getDataSetId(queryCtx);
            if (dataSetId == null) {
                return;
            }
            log.info("try generating query statement for dataSetId:{}", (Object)dataSetId);
            this.tryParse(queryCtx, dataSetId);
        }
        catch (Exception e) {
            log.error("failed to parse query:", (Throwable)e);
        }
    }

    private void tryParse(ChatQueryContext queryCtx, Long dataSetId) {
        LLMRequestService requestService = (LLMRequestService)ContextUtils.getBean(LLMRequestService.class);
        LLMResponseService responseService = (LLMResponseService)ContextUtils.getBean(LLMResponseService.class);
        int maxRetries = ((LLMParserConfig)ContextUtils.getBean(LLMParserConfig.class)).getRecallMaxRetries();
        LLMReq llmReq = requestService.getLlmReq(queryCtx, dataSetId);
        Map<Object, Object> sqlRespMap = new HashMap();
        ParseResult parseResult = null;
        for (int currentRetry = 1; currentRetry <= maxRetries; ++currentRetry) {
            log.info("currentRetryRound:{}, start runText2SQL", (Object)currentRetry);
            try {
                LLMResp llmResp = requestService.runText2SQL(llmReq);
                if (!Objects.nonNull(llmResp) || !MapUtils.isNotEmpty(sqlRespMap = responseService.getDeduplicationSqlResp(currentRetry, llmResp))) continue;
                parseResult = ParseResult.builder().dataSetId(dataSetId).llmReq(llmReq).llmResp(llmResp).linkingValues(llmReq.getLinking()).build();
                break;
            }
            catch (Exception e) {
                log.error("currentRetryRound:{}, runText2SQL failed", (Object)currentRetry, (Object)e);
            }
        }
        if (MapUtils.isEmpty(sqlRespMap)) {
            return;
        }
        for (Map.Entry entry : sqlRespMap.entrySet()) {
            String sql = (String)entry.getKey();
            double sqlWeight = ((LLMSqlResp)entry.getValue()).getSqlWeight();
            responseService.addParseInfo(queryCtx, parseResult, sql, sqlWeight);
        }
    }
}

