/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.rule;

import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import com.tencent.supersonic.headless.chat.query.rule.metric.MetricIdQuery;
import com.tencent.supersonic.headless.chat.query.rule.metric.MetricModelQuery;
import com.tencent.supersonic.headless.chat.query.rule.metric.MetricSemanticQuery;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInheritParser
implements SemanticParser {
    private static final Logger log = LoggerFactory.getLogger(ContextInheritParser.class);
    private static final Map<SchemaElementType, List<SchemaElementType>> MUTUAL_EXCLUSIVE_MAP = Stream.of(new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.METRIC, Arrays.asList(SchemaElementType.METRIC)), new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.DIMENSION, Arrays.asList(SchemaElementType.DIMENSION, SchemaElementType.VALUE)), new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.VALUE, Arrays.asList(SchemaElementType.VALUE, SchemaElementType.DIMENSION)), new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.ENTITY, Arrays.asList(SchemaElementType.ENTITY)), new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.DATASET, Arrays.asList(SchemaElementType.DATASET)), new AbstractMap.SimpleEntry<SchemaElementType, List<SchemaElementType>>(SchemaElementType.ID, Arrays.asList(SchemaElementType.ID))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    @Override
    public void parse(ChatQueryContext chatQueryContext, ChatContext chatContext) {
        if (!this.shouldInherit(chatQueryContext)) {
            return;
        }
        Long dataSetId = this.getMatchedDataSet(chatQueryContext, chatContext);
        if (dataSetId == null) {
            return;
        }
        List elementMatches = chatQueryContext.getMapInfo().getMatchedElements(dataSetId);
        ArrayList<SchemaElementMatch> matchesToInherit = new ArrayList<SchemaElementMatch>();
        for (SchemaElementMatch match : chatContext.getParseInfo().getElementMatches()) {
            RuleSemanticQuery ruleQuery;
            SchemaElementType matchType = match.getElement().getType();
            if (this.containsTypes(elementMatches, matchType, ruleQuery = QueryManager.getRuleQuery(chatContext.getParseInfo().getQueryMode()))) continue;
            match.setInherited(true);
            matchesToInherit.add(match);
        }
        elementMatches.addAll(matchesToInherit);
        List<RuleSemanticQuery> queries = RuleSemanticQuery.resolve(dataSetId, elementMatches, chatQueryContext);
        for (RuleSemanticQuery query : queries) {
            query.fillParseInfo(chatQueryContext, chatContext);
            if (this.existSameQuery(query.getParseInfo().getDataSetId(), query.getQueryMode(), chatQueryContext)) continue;
            chatQueryContext.getCandidateQueries().add(query);
        }
    }

    private boolean existSameQuery(Long dataSetId, String queryMode, ChatQueryContext chatQueryContext) {
        for (SemanticQuery semanticQuery : chatQueryContext.getCandidateQueries()) {
            if (!semanticQuery.getQueryMode().equals(queryMode) || !semanticQuery.getParseInfo().getDataSetId().equals(dataSetId)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTypes(List<SchemaElementMatch> matches, SchemaElementType matchType, RuleSemanticQuery ruleQuery) {
        List<SchemaElementType> types = MUTUAL_EXCLUSIVE_MAP.get(matchType);
        return matches.stream().anyMatch(m -> {
            SchemaElementType type = m.getElement().getType();
            if (Objects.nonNull(ruleQuery) && ruleQuery instanceof MetricSemanticQuery && !(ruleQuery instanceof MetricIdQuery)) {
                return types.contains(type);
            }
            return type.equals((Object)matchType);
        });
    }

    protected boolean shouldInherit(ChatQueryContext chatQueryContext) {
        List metricModelQueries = chatQueryContext.getCandidateQueries().stream().filter(query -> query instanceof MetricModelQuery).collect(Collectors.toList());
        return metricModelQueries.size() == chatQueryContext.getCandidateQueries().size();
    }

    protected Long getMatchedDataSet(ChatQueryContext chatQueryContext, ChatContext chatContext) {
        Long dataSetId = chatContext.getParseInfo().getDataSetId();
        if (dataSetId == null) {
            return null;
        }
        Set queryDataSets = chatQueryContext.getMapInfo().getMatchedDataSetInfos();
        if (queryDataSets.contains(dataSetId)) {
            return dataSetId;
        }
        return dataSetId;
    }
}

