/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query;

import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.Order;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.chat.parser.ParserConfig;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.chat.utils.QueryReqBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSemanticQuery
implements SemanticQuery,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BaseSemanticQuery.class);
    protected SemanticParseInfo parseInfo = new SemanticParseInfo();

    @Override
    public SemanticParseInfo getParseInfo() {
        return this.parseInfo;
    }

    @Override
    public void setParseInfo(SemanticParseInfo parseInfo) {
        this.parseInfo = parseInfo;
    }

    protected QueryStructReq convertQueryStruct() {
        return QueryReqBuilder.buildStructReq(this.parseInfo);
    }

    protected void convertBizNameToName(SemanticSchema semanticSchema, QueryStructReq queryStructReq) {
        List dimensionFilters;
        List groups;
        List aggregators;
        Map bizNameToName = semanticSchema.getBizNameToName(queryStructReq.getDataSetId());
        bizNameToName.putAll(TimeDimensionEnum.getNameToNameMap());
        List orders = queryStructReq.getOrders();
        if (CollectionUtils.isNotEmpty((Collection)orders)) {
            for (Order order : orders) {
                order.setColumn((String)bizNameToName.get(order.getColumn()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(aggregators = queryStructReq.getAggregators()))) {
            for (Aggregator aggregator : aggregators) {
                aggregator.setColumn((String)bizNameToName.get(aggregator.getColumn()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(groups = queryStructReq.getGroups()))) {
            groups = groups.stream().map(bizNameToName::get).collect(Collectors.toList());
            queryStructReq.setGroups(groups);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dimensionFilters = queryStructReq.getDimensionFilters()))) {
            dimensionFilters.forEach(filter -> filter.setName((String)bizNameToName.get(filter.getBizName())));
        }
        List metricFilters = queryStructReq.getMetricFilters();
        if (CollectionUtils.isNotEmpty((Collection)dimensionFilters)) {
            metricFilters.forEach(filter -> filter.setName((String)bizNameToName.get(filter.getBizName())));
        }
    }

    protected void initS2SqlByStruct(SemanticSchema semanticSchema) {
        ParserConfig parserConfig = (ParserConfig)((Object)ContextUtils.getBean(ParserConfig.class));
        boolean s2sqlEnable = Boolean.valueOf(parserConfig.getParameterValue(ParserConfig.PARSER_S2SQL_ENABLE));
        if (!s2sqlEnable) {
            return;
        }
        QueryStructReq queryStructReq = this.convertQueryStruct();
        this.convertBizNameToName(semanticSchema, queryStructReq);
        QuerySqlReq querySQLReq = queryStructReq.convert();
        this.parseInfo.getSqlInfo().setS2SQL(querySQLReq.getSql());
        this.parseInfo.getSqlInfo().setCorrectS2SQL(querySQLReq.getSql());
    }

    public String toString() {
        return "BaseSemanticQuery(parseInfo=" + this.getParseInfo() + ")";
    }
}

