/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule;

import com.tencent.supersonic.common.pojo.enums.AggregateTypeEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.chat.query.rule.QueryMatchOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryMatcher {
    private HashMap<SchemaElementType, QueryMatchOption> elementOptionMap = new HashMap();
    private boolean supportCompare;
    private boolean supportOrderBy;
    private List<AggregateTypeEnum> orderByTypes = Arrays.asList(AggregateTypeEnum.MAX, AggregateTypeEnum.MIN, AggregateTypeEnum.TOPN);

    public QueryMatcher() {
        for (SchemaElementType type : SchemaElementType.values()) {
            if (type.equals((Object)SchemaElementType.DATASET)) {
                this.elementOptionMap.put(type, QueryMatchOption.optional());
                continue;
            }
            this.elementOptionMap.put(type, QueryMatchOption.unused());
        }
    }

    public QueryMatcher addOption(SchemaElementType type, QueryMatchOption.OptionType option, QueryMatchOption.RequireNumberType requireNumberType, Integer requireNumber) {
        this.elementOptionMap.put(type, QueryMatchOption.build(option, requireNumberType, requireNumber));
        return this;
    }

    public List<SchemaElementMatch> match(List<SchemaElementMatch> candidateElementMatches) {
        ArrayList<SchemaElementMatch> elementMatches = new ArrayList<SchemaElementMatch>();
        HashMap<SchemaElementType, Integer> schemaElementTypeCount = new HashMap<SchemaElementType, Integer>();
        for (SchemaElementMatch schemaElementMatch : candidateElementMatches) {
            SchemaElementType schemaElementType = schemaElementMatch.getElement().getType();
            if (schemaElementTypeCount.containsKey(schemaElementType)) {
                schemaElementTypeCount.put(schemaElementType, (Integer)schemaElementTypeCount.get(schemaElementType) + 1);
                continue;
            }
            schemaElementTypeCount.put(schemaElementType, 1);
        }
        for (Map.Entry entry : this.elementOptionMap.entrySet()) {
            SchemaElementType elementType = (SchemaElementType)entry.getKey();
            QueryMatchOption elementOption = (QueryMatchOption)entry.getValue();
            if (this.isMatch(elementOption, this.getCount(schemaElementTypeCount, elementType))) continue;
            return new ArrayList<SchemaElementMatch>();
        }
        for (SchemaElementMatch schemaElementMatch : candidateElementMatches) {
            QueryMatchOption elementOption = this.elementOptionMap.get(schemaElementMatch.getElement().getType());
            if (!Objects.nonNull(elementOption) || elementOption.getSchemaElementOption().equals((Object)QueryMatchOption.OptionType.UNUSED)) continue;
            elementMatches.add(schemaElementMatch);
        }
        return elementMatches;
    }

    private int getCount(HashMap<SchemaElementType, Integer> schemaElementTypeCount, SchemaElementType schemaElementType) {
        if (schemaElementTypeCount.containsKey(schemaElementType)) {
            return schemaElementTypeCount.get(schemaElementType);
        }
        return 0;
    }

    private boolean isMatch(QueryMatchOption queryMatchOption, int count) {
        if (queryMatchOption.getSchemaElementOption().equals((Object)QueryMatchOption.OptionType.REQUIRED) && count <= 0) {
            return false;
        }
        if (queryMatchOption.getRequireNumberType().equals((Object)QueryMatchOption.RequireNumberType.AT_LEAST) && count < queryMatchOption.getRequireNumber()) {
            return false;
        }
        return !queryMatchOption.getRequireNumberType().equals((Object)QueryMatchOption.RequireNumberType.AT_MOST) || count <= queryMatchOption.getRequireNumber();
    }

    public HashMap<SchemaElementType, QueryMatchOption> getElementOptionMap() {
        return this.elementOptionMap;
    }

    public boolean isSupportCompare() {
        return this.supportCompare;
    }

    public boolean isSupportOrderBy() {
        return this.supportOrderBy;
    }

    public List<AggregateTypeEnum> getOrderByTypes() {
        return this.orderByTypes;
    }

    public void setElementOptionMap(HashMap<SchemaElementType, QueryMatchOption> elementOptionMap) {
        this.elementOptionMap = elementOptionMap;
    }

    public void setSupportCompare(boolean supportCompare) {
        this.supportCompare = supportCompare;
    }

    public void setSupportOrderBy(boolean supportOrderBy) {
        this.supportOrderBy = supportOrderBy;
    }

    public void setOrderByTypes(List<AggregateTypeEnum> orderByTypes) {
        this.orderByTypes = orderByTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryMatcher)) {
            return false;
        }
        QueryMatcher other = (QueryMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSupportCompare() != other.isSupportCompare()) {
            return false;
        }
        if (this.isSupportOrderBy() != other.isSupportOrderBy()) {
            return false;
        }
        HashMap<SchemaElementType, QueryMatchOption> this$elementOptionMap = this.getElementOptionMap();
        HashMap<SchemaElementType, QueryMatchOption> other$elementOptionMap = other.getElementOptionMap();
        if (this$elementOptionMap == null ? other$elementOptionMap != null : !((Object)this$elementOptionMap).equals(other$elementOptionMap)) {
            return false;
        }
        List<AggregateTypeEnum> this$orderByTypes = this.getOrderByTypes();
        List<AggregateTypeEnum> other$orderByTypes = other.getOrderByTypes();
        return !(this$orderByTypes == null ? other$orderByTypes != null : !((Object)this$orderByTypes).equals(other$orderByTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportCompare() ? 79 : 97);
        result = result * 59 + (this.isSupportOrderBy() ? 79 : 97);
        HashMap<SchemaElementType, QueryMatchOption> $elementOptionMap = this.getElementOptionMap();
        result = result * 59 + ($elementOptionMap == null ? 43 : ((Object)$elementOptionMap).hashCode());
        List<AggregateTypeEnum> $orderByTypes = this.getOrderByTypes();
        result = result * 59 + ($orderByTypes == null ? 43 : ((Object)$orderByTypes).hashCode());
        return result;
    }

    public String toString() {
        return "QueryMatcher(elementOptionMap=" + this.getElementOptionMap() + ", supportCompare=" + this.isSupportCompare() + ", supportOrderBy=" + this.isSupportOrderBy() + ", orderByTypes=" + this.getOrderByTypes() + ")";
    }
}

