/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.chat.ChatContext;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.query.BaseSemanticQuery;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.rule.QueryMatcher;
import com.tencent.supersonic.headless.chat.utils.QueryReqBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuleSemanticQuery
extends BaseSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(RuleSemanticQuery.class);
    protected QueryMatcher queryMatcher = new QueryMatcher();

    public RuleSemanticQuery() {
        QueryManager.register(this);
    }

    public List<SchemaElementMatch> match(List<SchemaElementMatch> candidateElementMatches, ChatQueryContext queryCtx) {
        return this.queryMatcher.match(candidateElementMatches);
    }

    @Override
    public void initS2Sql(SemanticSchema semanticSchema, User user) {
        this.initS2SqlByStruct(semanticSchema);
    }

    public void fillParseInfo(ChatQueryContext chatQueryContext, ChatContext chatContext) {
        this.parseInfo.setQueryMode(this.getQueryMode());
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        this.fillSchemaElement(this.parseInfo, semanticSchema);
        this.fillScore(this.parseInfo);
        this.fillDateConf(this.parseInfo, chatContext.getParseInfo());
    }

    private void fillDateConf(SemanticParseInfo queryParseInfo, SemanticParseInfo chatParseInfo) {
        if (queryParseInfo.getDateInfo() != null || chatParseInfo.getDateInfo() == null) {
            return;
        }
        if (QueryManager.isTagQuery(queryParseInfo.getQueryMode()) && QueryManager.isTagQuery(chatParseInfo.getQueryMode()) || QueryManager.isMetricQuery(queryParseInfo.getQueryMode()) && QueryManager.isMetricQuery(chatParseInfo.getQueryMode())) {
            queryParseInfo.setDateInfo(chatParseInfo.getDateInfo());
            queryParseInfo.getDateInfo().setInherited(true);
        }
    }

    private void fillScore(SemanticParseInfo parseInfo) {
        double totalScore = 0.0;
        HashMap<SchemaElementType, SchemaElementMatch> maxSimilarityMatch = new HashMap<SchemaElementType, SchemaElementMatch>();
        for (SchemaElementMatch match : parseInfo.getElementMatches()) {
            SchemaElementType type = match.getElement().getType();
            if (maxSimilarityMatch.containsKey(type) && !(match.getSimilarity() > ((SchemaElementMatch)maxSimilarityMatch.get(type)).getSimilarity())) continue;
            maxSimilarityMatch.put(type, match);
        }
        for (SchemaElementMatch match : maxSimilarityMatch.values()) {
            totalScore += (double)match.getDetectWord().length() * match.getSimilarity();
        }
        parseInfo.setScore(parseInfo.getScore() + totalScore);
    }

    private void fillSchemaElement(SemanticParseInfo parseInfo, SemanticSchema semanticSchema) {
        Set dataSetIds = parseInfo.getElementMatches().stream().map(SchemaElementMatch::getElement).map(SchemaElement::getDataSet).collect(Collectors.toSet());
        Long dataSetId = (Long)dataSetIds.iterator().next();
        parseInfo.setDataSet(semanticSchema.getDataSet(dataSetId));
        HashMap<Long, List<SchemaElementMatch>> dim2Values = new HashMap<Long, List<SchemaElementMatch>>();
        HashMap<Long, List<SchemaElementMatch>> id2Values = new HashMap<Long, List<SchemaElementMatch>>();
        for (SchemaElementMatch schemaMatch : parseInfo.getElementMatches()) {
            SchemaElement element = schemaMatch.getElement();
            element.setOrder(1.0 - schemaMatch.getSimilarity());
            switch (element.getType()) {
                case ID: {
                    SchemaElement entityElement = semanticSchema.getElement(SchemaElementType.ENTITY, element.getId().longValue());
                    if (entityElement == null) break;
                    if (id2Values.containsKey(element.getId())) {
                        ((List)id2Values.get(element.getId())).add(schemaMatch);
                        break;
                    }
                    id2Values.put(element.getId(), new ArrayList<SchemaElementMatch>(Arrays.asList(schemaMatch)));
                    break;
                }
                case VALUE: {
                    SchemaElement dimElement = semanticSchema.getElement(SchemaElementType.DIMENSION, element.getId().longValue());
                    if (dimElement == null) break;
                    if (dim2Values.containsKey(element.getId())) {
                        ((List)dim2Values.get(element.getId())).add(schemaMatch);
                        break;
                    }
                    dim2Values.put(element.getId(), new ArrayList<SchemaElementMatch>(Arrays.asList(schemaMatch)));
                    break;
                }
                case DIMENSION: {
                    parseInfo.getDimensions().add(element);
                    break;
                }
                case METRIC: {
                    parseInfo.getMetrics().add(element);
                    break;
                }
                case ENTITY: {
                    parseInfo.setEntity(element);
                    break;
                }
            }
        }
        this.addToFilters(id2Values, parseInfo, semanticSchema, SchemaElementType.ENTITY);
        this.addToFilters(dim2Values, parseInfo, semanticSchema, SchemaElementType.DIMENSION);
    }

    private void addToFilters(Map<Long, List<SchemaElementMatch>> id2Values, SemanticParseInfo parseInfo, SemanticSchema semanticSchema, SchemaElementType entity) {
        if (id2Values == null || id2Values.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, List<SchemaElementMatch>> entry : id2Values.entrySet()) {
            SchemaElement dimension = semanticSchema.getElement(entity, entry.getKey().longValue());
            if (entry.getValue().size() == 1) {
                SchemaElementMatch schemaMatch = entry.getValue().get(0);
                QueryFilter dimensionFilter = new QueryFilter();
                dimensionFilter.setValue((Object)schemaMatch.getWord());
                dimensionFilter.setBizName(dimension.getBizName());
                dimensionFilter.setName(dimension.getName());
                dimensionFilter.setOperator(FilterOperatorEnum.EQUALS);
                dimensionFilter.setElementID(schemaMatch.getElement().getId());
                parseInfo.setEntity(semanticSchema.getElement(SchemaElementType.ENTITY, entry.getKey().longValue()));
                parseInfo.getDimensionFilters().add(dimensionFilter);
                continue;
            }
            QueryFilter dimensionFilter = new QueryFilter();
            ArrayList vals = new ArrayList();
            entry.getValue().stream().forEach(i -> vals.add(i.getWord()));
            dimensionFilter.setValue(vals);
            dimensionFilter.setBizName(dimension.getBizName());
            dimensionFilter.setName(dimension.getName());
            dimensionFilter.setOperator(FilterOperatorEnum.IN);
            dimensionFilter.setElementID(entry.getKey());
            parseInfo.getDimensionFilters().add(dimensionFilter);
        }
    }

    private void addToValues(SemanticSchema semanticSchema, SchemaElementType entity, Map<Long, List<SchemaElementMatch>> id2Values, SchemaElementMatch schemaMatch) {
        SchemaElement element = schemaMatch.getElement();
        SchemaElement entityElement = semanticSchema.getElement(entity, element.getId().longValue());
        if (entityElement != null) {
            if (id2Values.containsKey(element.getId())) {
                id2Values.get(element.getId()).add(schemaMatch);
            } else {
                id2Values.put(element.getId(), new ArrayList<SchemaElementMatch>(Arrays.asList(schemaMatch)));
            }
        }
    }

    @Override
    public SemanticQueryReq buildSemanticQueryReq() {
        String queryMode = this.parseInfo.getQueryMode();
        if (this.parseInfo.getDataSetId() == null || StringUtils.isEmpty((CharSequence)queryMode) || !QueryManager.containsRuleQuery(queryMode)) {
            log.error("not find QueryMode");
            throw new RuntimeException("not find QueryMode");
        }
        QueryStructReq queryStructReq = this.convertQueryStruct();
        return queryStructReq.convert(true);
    }

    protected boolean isMultiStructQuery() {
        return false;
    }

    public SemanticQueryReq multiStructExecute() {
        String queryMode = this.parseInfo.getQueryMode();
        if (this.parseInfo.getDataSetId() != null || StringUtils.isEmpty((CharSequence)queryMode) || !QueryManager.containsRuleQuery(queryMode)) {
            log.error("not find QueryMode");
            throw new RuntimeException("not find QueryMode");
        }
        return this.convertQueryMultiStruct();
    }

    @Override
    public void setParseInfo(SemanticParseInfo parseInfo) {
        this.parseInfo = parseInfo;
    }

    public static List<RuleSemanticQuery> resolve(Long dataSetId, List<SchemaElementMatch> candidateElementMatches, ChatQueryContext chatQueryContext) {
        ArrayList<RuleSemanticQuery> matchedQueries = new ArrayList<RuleSemanticQuery>();
        for (RuleSemanticQuery semanticQuery : QueryManager.getRuleQueries()) {
            List<SchemaElementMatch> matches = semanticQuery.match(candidateElementMatches, chatQueryContext);
            if (matches.size() <= 0) continue;
            RuleSemanticQuery query = QueryManager.createRuleQuery(semanticQuery.getQueryMode());
            query.getParseInfo().getElementMatches().addAll(matches);
            matchedQueries.add(query);
        }
        return matchedQueries;
    }

    @Override
    protected QueryStructReq convertQueryStruct() {
        return QueryReqBuilder.buildStructReq(this.parseInfo);
    }

    protected QueryMultiStructReq convertQueryMultiStruct() {
        return QueryReqBuilder.buildMultiStructReq(this.parseInfo);
    }

    @Override
    public String toString() {
        return "RuleSemanticQuery(queryMatcher=" + this.queryMatcher + ")";
    }
}

