/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.query.rule.metric;

import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.FilterType;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.chat.query.rule.QueryMatchOption;
import com.tencent.supersonic.headless.chat.query.rule.metric.MetricSemanticQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetricFilterQuery
extends MetricSemanticQuery {
    private static final Logger log = LoggerFactory.getLogger(MetricFilterQuery.class);
    public static final String QUERY_MODE = "METRIC_FILTER";

    public MetricFilterQuery() {
        this.queryMatcher.addOption(SchemaElementType.VALUE, QueryMatchOption.OptionType.REQUIRED, QueryMatchOption.RequireNumberType.AT_LEAST, 1);
    }

    @Override
    public String getQueryMode() {
        return QUERY_MODE;
    }

    @Override
    public SemanticQueryReq buildSemanticQueryReq() {
        if (!this.isMultiStructQuery()) {
            return super.buildSemanticQueryReq();
        }
        return super.multiStructExecute();
    }

    @Override
    protected boolean isMultiStructQuery() {
        HashSet filterBizName = new HashSet();
        this.parseInfo.getDimensionFilters().forEach(filter -> filterBizName.add(filter.getBizName()));
        return FilterType.UNION.equals((Object)this.parseInfo.getFilterType()) && filterBizName.size() > 1;
    }

    @Override
    protected QueryStructReq convertQueryStruct() {
        QueryStructReq queryStructReq = super.convertQueryStruct();
        this.addDimension(queryStructReq, true);
        return queryStructReq;
    }

    @Override
    protected QueryMultiStructReq convertQueryMultiStruct() {
        QueryMultiStructReq queryMultiStructReq = super.convertQueryMultiStruct();
        for (QueryStructReq queryStructReq : queryMultiStructReq.getQueryStructReqs()) {
            this.addDimension(queryStructReq, false);
        }
        return queryMultiStructReq;
    }

    private void addDimension(QueryStructReq queryStructReq, boolean onlyOperateInFilter) {
        if (!queryStructReq.getDimensionFilters().isEmpty()) {
            List dimensions = queryStructReq.getGroups();
            log.debug("addDimension before [{}]", (Object)queryStructReq.getGroups());
            List<Object> filters = new ArrayList(queryStructReq.getDimensionFilters());
            if (onlyOperateInFilter) {
                filters = filters.stream().filter(filter -> filter.getOperator().equals((Object)FilterOperatorEnum.IN)).collect(Collectors.toList());
            }
            filters.forEach(d -> {
                if (!dimensions.contains(d.getBizName())) {
                    dimensions.add(d.getBizName());
                }
            });
            queryStructReq.setGroups(dimensions);
            log.debug("addDimension after [{}]", (Object)queryStructReq.getGroups());
        }
    }
}

