/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.utils;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.chat.parser.llm.DataSetResolver;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ComponentFactory {
    private static final Logger log = LoggerFactory.getLogger(ComponentFactory.class);
    private static DataSetResolver modelResolver;

    public static DataSetResolver getModelResolver() {
        if (Objects.isNull(modelResolver)) {
            modelResolver = ComponentFactory.init(DataSetResolver.class);
        }
        return modelResolver;
    }

    public static <T> T getBean(String name, Class<T> tClass) {
        return (T)ContextUtils.getContext().getBean(name, tClass);
    }

    private static <T> List<T> init(Class<T> factoryType, List list) {
        list.addAll(SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        return list;
    }

    private static <T> T init(Class<T> factoryType) {
        return (T)SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()).get(0);
    }
}

