/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.utils;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.Order;
import com.tencent.supersonic.common.pojo.enums.AggOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.AggregateTypeEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SqlInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryMultiStructReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class QueryReqBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryReqBuilder.class);

    public static QueryStructReq buildStructReq(SemanticParseInfo parseInfo) {
        QueryStructReq queryStructReq = new QueryStructReq();
        queryStructReq.setDataSetId(parseInfo.getDataSetId());
        queryStructReq.setDataSetName(parseInfo.getDataSet().getName());
        queryStructReq.setBusinessType(parseInfo.getDataSet().getBusinessType());
        queryStructReq.setQueryType(parseInfo.getQueryType());
        queryStructReq.setDateInfo(QueryReqBuilder.rewrite2Between(parseInfo.getDateInfo()));
        List<Filter> dimensionFilters = QueryReqBuilder.getFilters(parseInfo.getDimensionFilters());
        queryStructReq.setDimensionFilters(dimensionFilters);
        List metricFilters = parseInfo.getMetricFilters().stream().map(chatFilter -> new Filter(chatFilter.getBizName(), chatFilter.getOperator(), chatFilter.getValue())).collect(Collectors.toList());
        queryStructReq.setMetricFilters(metricFilters);
        QueryReqBuilder.addDateDimension(parseInfo);
        List dimensions = parseInfo.getDimensions().stream().map(SchemaElement::getBizName).collect(Collectors.toList());
        queryStructReq.setGroups(dimensions);
        Set metrics = parseInfo.getMetrics();
        if (!CollectionUtils.isEmpty((Collection)metrics)) {
            SchemaElement metricElement = (SchemaElement)parseInfo.getMetrics().iterator().next();
            Set<Order> order = QueryReqBuilder.getOrder(parseInfo.getOrders(), parseInfo.getAggType(), metricElement);
            queryStructReq.setAggregators(QueryReqBuilder.getAggregatorByMetric(parseInfo.getAggType(), metricElement));
            queryStructReq.setOrders(new ArrayList<Order>(order));
        }
        QueryReqBuilder.deletionDuplicated(queryStructReq);
        return queryStructReq;
    }

    private static List<Filter> getFilters(Set<QueryFilter> queryFilters) {
        List<Filter> dimensionFilters = queryFilters.stream().filter(chatFilter -> StringUtils.isNotEmpty((CharSequence)chatFilter.getBizName())).map(chatFilter -> new Filter(chatFilter.getBizName(), chatFilter.getOperator(), chatFilter.getValue())).collect(Collectors.toList());
        return dimensionFilters;
    }

    private static void deletionDuplicated(QueryStructReq queryStructReq) {
        if (!CollectionUtils.isEmpty((Collection)queryStructReq.getGroups()) && queryStructReq.getGroups().size() > 1) {
            HashSet groups = new HashSet();
            groups.addAll(queryStructReq.getGroups());
            queryStructReq.getGroups().clear();
            queryStructReq.getGroups().addAll(groups);
        }
    }

    private static DateConf rewrite2Between(DateConf dateInfo) {
        DateConf dateInfoNew = new DateConf();
        BeanUtils.copyProperties((Object)dateInfo, (Object)dateInfoNew);
        if (Objects.nonNull(dateInfo) && DateConf.DateMode.RECENT.equals((Object)dateInfo.getDateMode())) {
            int unit = dateInfo.getUnit();
            int days = 1;
            switch (dateInfo.getPeriod()) {
                case "DAY": {
                    days = 1;
                    break;
                }
                case "WEEK": {
                    days = 7;
                    break;
                }
                case "MONTH": {
                    days = 30;
                    break;
                }
                case "YEAR": {
                    days = 365;
                    break;
                }
            }
            String startDate = LocalDate.now().plusDays(-(unit * days)).toString();
            String endDate = LocalDate.now().plusDays(-1L).toString();
            dateInfoNew.setDateMode(DateConf.DateMode.BETWEEN);
            dateInfoNew.setStartDate(startDate);
            dateInfoNew.setEndDate(endDate);
        }
        return dateInfoNew;
    }

    public static QueryMultiStructReq buildMultiStructReq(SemanticParseInfo parseInfo) {
        QueryStructReq queryStructReq = QueryReqBuilder.buildStructReq(parseInfo);
        QueryMultiStructReq queryMultiStructReq = new QueryMultiStructReq();
        ArrayList queryStructReqs = Lists.newArrayList();
        for (Filter dimensionFilter : queryStructReq.getDimensionFilters()) {
            QueryStructReq req = new QueryStructReq();
            BeanUtils.copyProperties((Object)queryStructReq, (Object)req);
            req.setDataSetId(parseInfo.getDataSetId());
            req.setDimensionFilters((List)Lists.newArrayList((Object[])new Filter[]{dimensionFilter}));
            req.setSqlInfo(parseInfo.getSqlInfo());
            queryStructReqs.add(req);
        }
        queryMultiStructReq.setQueryStructReqs((List)queryStructReqs);
        return queryMultiStructReq;
    }

    public static QuerySqlReq buildS2SQLReq(String querySql, Long dataSetId) {
        QuerySqlReq querySQLReq = new QuerySqlReq();
        if (Objects.nonNull(querySql)) {
            querySQLReq.setSql(querySql);
        }
        querySQLReq.setDataSetId(dataSetId);
        return querySQLReq;
    }

    public static QuerySqlReq buildS2SQLReq(SqlInfo sqlInfo, Long dataSetId) {
        QuerySqlReq querySQLReq = new QuerySqlReq();
        if (Objects.nonNull(sqlInfo.getCorrectS2SQL())) {
            querySQLReq.setSql(sqlInfo.getCorrectS2SQL());
        }
        querySQLReq.setSqlInfo(sqlInfo);
        querySQLReq.setDataSetId(dataSetId);
        return querySQLReq;
    }

    private static List<Aggregator> getAggregatorByMetric(AggregateTypeEnum aggregateType, SchemaElement metric) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        if (metric != null) {
            String agg = "";
            if (Objects.isNull(aggregateType) || aggregateType.equals((Object)AggregateTypeEnum.NONE) || AggOperatorEnum.COUNT_DISTINCT.name().equalsIgnoreCase(metric.getDefaultAgg())) {
                if (StringUtils.isNotBlank((CharSequence)metric.getDefaultAgg())) {
                    agg = metric.getDefaultAgg();
                }
            } else {
                agg = aggregateType.name();
            }
            aggregators.add(new Aggregator(metric.getBizName(), AggOperatorEnum.of((String)agg)));
        }
        return aggregators;
    }

    private static void addDateDimension(SemanticParseInfo parseInfo) {
        if (parseInfo != null) {
            String queryMode = parseInfo.getQueryMode();
            if (parseInfo.getDateInfo() == null) {
                return;
            }
            if (parseInfo.getAggType() != null && (parseInfo.getAggType().equals((Object)AggregateTypeEnum.MAX) || parseInfo.getAggType().equals((Object)AggregateTypeEnum.MIN)) && !CollectionUtils.isEmpty((Collection)parseInfo.getDimensions())) {
                return;
            }
            DateConf dateInfo = parseInfo.getDateInfo();
            String dateField = QueryReqBuilder.getDateField(dateInfo);
            for (SchemaElement dimension : parseInfo.getDimensions()) {
                if (!dimension.getBizName().equalsIgnoreCase(dateField)) continue;
                return;
            }
            if (Objects.nonNull(parseInfo.getAggType()) && !parseInfo.getAggType().equals((Object)AggregateTypeEnum.NONE)) {
                return;
            }
            SchemaElement dimension = new SchemaElement();
            dimension.setBizName(dateField);
            if (QueryManager.isMetricQuery(queryMode)) {
                List<String> timeDimensions = Arrays.asList(TimeDimensionEnum.DAY.getName(), TimeDimensionEnum.WEEK.getName(), TimeDimensionEnum.MONTH.getName());
                Set dimensions = parseInfo.getDimensions().stream().filter(d -> !timeDimensions.contains(d.getBizName().toLowerCase())).collect(Collectors.toSet());
                dimensions.add(dimension);
                parseInfo.setDimensions(dimensions);
            }
        }
    }

    public static Set<Order> getOrder(Set<Order> parseOrder, AggregateTypeEnum aggregator, SchemaElement metric) {
        if (!CollectionUtils.isEmpty(parseOrder)) {
            return parseOrder;
        }
        LinkedHashSet<Order> orders = new LinkedHashSet<Order>();
        if (metric == null) {
            return orders;
        }
        if (AggregateTypeEnum.TOPN.equals((Object)aggregator) || AggregateTypeEnum.MAX.equals((Object)aggregator) || AggregateTypeEnum.MIN.equals((Object)aggregator)) {
            Order order = new Order();
            order.setColumn(metric.getBizName());
            order.setDirection("desc");
            orders.add(order);
        }
        return orders;
    }

    public static String getDateField(DateConf dateConf) {
        if (Objects.isNull(dateConf)) {
            return "";
        }
        String dateField = TimeDimensionEnum.DAY.getName();
        if ("MONTH".equals(dateConf.getPeriod())) {
            dateField = TimeDimensionEnum.MONTH.getName();
        }
        if ("WEEK".equals(dateConf.getPeriod())) {
            dateField = TimeDimensionEnum.WEEK.getName();
        }
        return dateField;
    }

    public static QueryStructReq buildStructRatioReq(SemanticParseInfo parseInfo, SchemaElement metric, AggOperatorEnum aggOperatorEnum) {
        QueryStructReq queryStructReq = QueryReqBuilder.buildStructReq(parseInfo);
        queryStructReq.setQueryType(QueryType.METRIC);
        queryStructReq.setOrders(new ArrayList());
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        Aggregator ratioRoll = new Aggregator(metric.getBizName(), aggOperatorEnum);
        aggregators.add(ratioRoll);
        queryStructReq.setAggregators(aggregators);
        return queryStructReq;
    }
}

