/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.config.PromptConfig;
import com.tencent.supersonic.common.pojo.ChatModelConfig;
import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.common.pojo.enums.Text2SQLType;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.QueryDataType;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.enums.ChatWorkflowState;
import com.tencent.supersonic.headless.api.pojo.enums.MapModeEnum;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.chat.parser.ParserConfig;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ChatQueryContext {
    private String queryText;
    private Set<Long> dataSetIds;
    private Map<Long, List<Long>> modelIdToDataSetIds;
    private User user;
    private boolean saveAnswer;
    private Text2SQLType text2SQLType;
    private QueryFilters queryFilters;
    private List<SemanticQuery> candidateQueries = new ArrayList<SemanticQuery>();
    private SchemaMapInfo mapInfo = new SchemaMapInfo();
    private MapModeEnum mapModeEnum = MapModeEnum.STRICT;
    @JsonIgnore
    private SemanticSchema semanticSchema;
    @JsonIgnore
    private ChatWorkflowState chatWorkflowState;
    private QueryDataType queryDataType = QueryDataType.ALL;
    private ChatModelConfig modelConfig;
    private PromptConfig promptConfig;
    private List<SqlExemplar> dynamicExemplars;
    private SemanticParseInfo contextParseInfo;

    public List<SemanticQuery> getCandidateQueries() {
        ParserConfig parserConfig = (ParserConfig)((Object)ContextUtils.getBean(ParserConfig.class));
        int parseShowCount = Integer.valueOf(parserConfig.getParameterValue(ParserConfig.PARSER_SHOW_COUNT));
        this.candidateQueries = this.candidateQueries.stream().sorted(Comparator.comparing(semanticQuery -> semanticQuery.getParseInfo().getScore(), Comparator.reverseOrder())).limit(parseShowCount).collect(Collectors.toList());
        return this.candidateQueries;
    }

    private static Text2SQLType $default$text2SQLType() {
        return Text2SQLType.RULE_AND_LLM;
    }

    public static ChatQueryContextBuilder builder() {
        return new ChatQueryContextBuilder();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public Set<Long> getDataSetIds() {
        return this.dataSetIds;
    }

    public Map<Long, List<Long>> getModelIdToDataSetIds() {
        return this.modelIdToDataSetIds;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isSaveAnswer() {
        return this.saveAnswer;
    }

    public Text2SQLType getText2SQLType() {
        return this.text2SQLType;
    }

    public QueryFilters getQueryFilters() {
        return this.queryFilters;
    }

    public SchemaMapInfo getMapInfo() {
        return this.mapInfo;
    }

    public MapModeEnum getMapModeEnum() {
        return this.mapModeEnum;
    }

    public SemanticSchema getSemanticSchema() {
        return this.semanticSchema;
    }

    public ChatWorkflowState getChatWorkflowState() {
        return this.chatWorkflowState;
    }

    public QueryDataType getQueryDataType() {
        return this.queryDataType;
    }

    public ChatModelConfig getModelConfig() {
        return this.modelConfig;
    }

    public PromptConfig getPromptConfig() {
        return this.promptConfig;
    }

    public List<SqlExemplar> getDynamicExemplars() {
        return this.dynamicExemplars;
    }

    public SemanticParseInfo getContextParseInfo() {
        return this.contextParseInfo;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public void setDataSetIds(Set<Long> dataSetIds) {
        this.dataSetIds = dataSetIds;
    }

    public void setModelIdToDataSetIds(Map<Long, List<Long>> modelIdToDataSetIds) {
        this.modelIdToDataSetIds = modelIdToDataSetIds;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSaveAnswer(boolean saveAnswer) {
        this.saveAnswer = saveAnswer;
    }

    public void setText2SQLType(Text2SQLType text2SQLType) {
        this.text2SQLType = text2SQLType;
    }

    public void setQueryFilters(QueryFilters queryFilters) {
        this.queryFilters = queryFilters;
    }

    public void setCandidateQueries(List<SemanticQuery> candidateQueries) {
        this.candidateQueries = candidateQueries;
    }

    public void setMapInfo(SchemaMapInfo mapInfo) {
        this.mapInfo = mapInfo;
    }

    public void setMapModeEnum(MapModeEnum mapModeEnum) {
        this.mapModeEnum = mapModeEnum;
    }

    @JsonIgnore
    public void setSemanticSchema(SemanticSchema semanticSchema) {
        this.semanticSchema = semanticSchema;
    }

    @JsonIgnore
    public void setChatWorkflowState(ChatWorkflowState chatWorkflowState) {
        this.chatWorkflowState = chatWorkflowState;
    }

    public void setQueryDataType(QueryDataType queryDataType) {
        this.queryDataType = queryDataType;
    }

    public void setModelConfig(ChatModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    public void setPromptConfig(PromptConfig promptConfig) {
        this.promptConfig = promptConfig;
    }

    public void setDynamicExemplars(List<SqlExemplar> dynamicExemplars) {
        this.dynamicExemplars = dynamicExemplars;
    }

    public void setContextParseInfo(SemanticParseInfo contextParseInfo) {
        this.contextParseInfo = contextParseInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatQueryContext)) {
            return false;
        }
        ChatQueryContext other = (ChatQueryContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSaveAnswer() != other.isSaveAnswer()) {
            return false;
        }
        String this$queryText = this.getQueryText();
        String other$queryText = other.getQueryText();
        if (this$queryText == null ? other$queryText != null : !this$queryText.equals(other$queryText)) {
            return false;
        }
        Set<Long> this$dataSetIds = this.getDataSetIds();
        Set<Long> other$dataSetIds = other.getDataSetIds();
        if (this$dataSetIds == null ? other$dataSetIds != null : !((Object)this$dataSetIds).equals(other$dataSetIds)) {
            return false;
        }
        Map<Long, List<Long>> this$modelIdToDataSetIds = this.getModelIdToDataSetIds();
        Map<Long, List<Long>> other$modelIdToDataSetIds = other.getModelIdToDataSetIds();
        if (this$modelIdToDataSetIds == null ? other$modelIdToDataSetIds != null : !((Object)this$modelIdToDataSetIds).equals(other$modelIdToDataSetIds)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Text2SQLType this$text2SQLType = this.getText2SQLType();
        Text2SQLType other$text2SQLType = other.getText2SQLType();
        if (this$text2SQLType == null ? other$text2SQLType != null : !this$text2SQLType.equals(other$text2SQLType)) {
            return false;
        }
        QueryFilters this$queryFilters = this.getQueryFilters();
        QueryFilters other$queryFilters = other.getQueryFilters();
        if (this$queryFilters == null ? other$queryFilters != null : !this$queryFilters.equals(other$queryFilters)) {
            return false;
        }
        List<SemanticQuery> this$candidateQueries = this.getCandidateQueries();
        List<SemanticQuery> other$candidateQueries = other.getCandidateQueries();
        if (this$candidateQueries == null ? other$candidateQueries != null : !((Object)this$candidateQueries).equals(other$candidateQueries)) {
            return false;
        }
        SchemaMapInfo this$mapInfo = this.getMapInfo();
        SchemaMapInfo other$mapInfo = other.getMapInfo();
        if (this$mapInfo == null ? other$mapInfo != null : !this$mapInfo.equals(other$mapInfo)) {
            return false;
        }
        MapModeEnum this$mapModeEnum = this.getMapModeEnum();
        MapModeEnum other$mapModeEnum = other.getMapModeEnum();
        if (this$mapModeEnum == null ? other$mapModeEnum != null : !this$mapModeEnum.equals(other$mapModeEnum)) {
            return false;
        }
        SemanticSchema this$semanticSchema = this.getSemanticSchema();
        SemanticSchema other$semanticSchema = other.getSemanticSchema();
        if (this$semanticSchema == null ? other$semanticSchema != null : !this$semanticSchema.equals(other$semanticSchema)) {
            return false;
        }
        ChatWorkflowState this$chatWorkflowState = this.getChatWorkflowState();
        ChatWorkflowState other$chatWorkflowState = other.getChatWorkflowState();
        if (this$chatWorkflowState == null ? other$chatWorkflowState != null : !this$chatWorkflowState.equals(other$chatWorkflowState)) {
            return false;
        }
        QueryDataType this$queryDataType = this.getQueryDataType();
        QueryDataType other$queryDataType = other.getQueryDataType();
        if (this$queryDataType == null ? other$queryDataType != null : !this$queryDataType.equals(other$queryDataType)) {
            return false;
        }
        ChatModelConfig this$modelConfig = this.getModelConfig();
        ChatModelConfig other$modelConfig = other.getModelConfig();
        if (this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig)) {
            return false;
        }
        PromptConfig this$promptConfig = this.getPromptConfig();
        PromptConfig other$promptConfig = other.getPromptConfig();
        if (this$promptConfig == null ? other$promptConfig != null : !this$promptConfig.equals(other$promptConfig)) {
            return false;
        }
        List<SqlExemplar> this$dynamicExemplars = this.getDynamicExemplars();
        List<SqlExemplar> other$dynamicExemplars = other.getDynamicExemplars();
        if (this$dynamicExemplars == null ? other$dynamicExemplars != null : !((Object)this$dynamicExemplars).equals(other$dynamicExemplars)) {
            return false;
        }
        SemanticParseInfo this$contextParseInfo = this.getContextParseInfo();
        SemanticParseInfo other$contextParseInfo = other.getContextParseInfo();
        return !(this$contextParseInfo == null ? other$contextParseInfo != null : !this$contextParseInfo.equals(other$contextParseInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatQueryContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSaveAnswer() ? 79 : 97);
        String $queryText = this.getQueryText();
        result = result * 59 + ($queryText == null ? 43 : $queryText.hashCode());
        Set<Long> $dataSetIds = this.getDataSetIds();
        result = result * 59 + ($dataSetIds == null ? 43 : ((Object)$dataSetIds).hashCode());
        Map<Long, List<Long>> $modelIdToDataSetIds = this.getModelIdToDataSetIds();
        result = result * 59 + ($modelIdToDataSetIds == null ? 43 : ((Object)$modelIdToDataSetIds).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Text2SQLType $text2SQLType = this.getText2SQLType();
        result = result * 59 + ($text2SQLType == null ? 43 : $text2SQLType.hashCode());
        QueryFilters $queryFilters = this.getQueryFilters();
        result = result * 59 + ($queryFilters == null ? 43 : $queryFilters.hashCode());
        List<SemanticQuery> $candidateQueries = this.getCandidateQueries();
        result = result * 59 + ($candidateQueries == null ? 43 : ((Object)$candidateQueries).hashCode());
        SchemaMapInfo $mapInfo = this.getMapInfo();
        result = result * 59 + ($mapInfo == null ? 43 : $mapInfo.hashCode());
        MapModeEnum $mapModeEnum = this.getMapModeEnum();
        result = result * 59 + ($mapModeEnum == null ? 43 : $mapModeEnum.hashCode());
        SemanticSchema $semanticSchema = this.getSemanticSchema();
        result = result * 59 + ($semanticSchema == null ? 43 : $semanticSchema.hashCode());
        ChatWorkflowState $chatWorkflowState = this.getChatWorkflowState();
        result = result * 59 + ($chatWorkflowState == null ? 43 : $chatWorkflowState.hashCode());
        QueryDataType $queryDataType = this.getQueryDataType();
        result = result * 59 + ($queryDataType == null ? 43 : $queryDataType.hashCode());
        ChatModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        PromptConfig $promptConfig = this.getPromptConfig();
        result = result * 59 + ($promptConfig == null ? 43 : $promptConfig.hashCode());
        List<SqlExemplar> $dynamicExemplars = this.getDynamicExemplars();
        result = result * 59 + ($dynamicExemplars == null ? 43 : ((Object)$dynamicExemplars).hashCode());
        SemanticParseInfo $contextParseInfo = this.getContextParseInfo();
        result = result * 59 + ($contextParseInfo == null ? 43 : $contextParseInfo.hashCode());
        return result;
    }

    public String toString() {
        return "ChatQueryContext(queryText=" + this.getQueryText() + ", dataSetIds=" + this.getDataSetIds() + ", modelIdToDataSetIds=" + this.getModelIdToDataSetIds() + ", user=" + this.getUser() + ", saveAnswer=" + this.isSaveAnswer() + ", text2SQLType=" + this.getText2SQLType() + ", queryFilters=" + this.getQueryFilters() + ", candidateQueries=" + this.getCandidateQueries() + ", mapInfo=" + this.getMapInfo() + ", mapModeEnum=" + this.getMapModeEnum() + ", semanticSchema=" + this.getSemanticSchema() + ", chatWorkflowState=" + this.getChatWorkflowState() + ", queryDataType=" + this.getQueryDataType() + ", modelConfig=" + this.getModelConfig() + ", promptConfig=" + this.getPromptConfig() + ", dynamicExemplars=" + this.getDynamicExemplars() + ", contextParseInfo=" + this.getContextParseInfo() + ")";
    }

    public ChatQueryContext() {
        this.text2SQLType = ChatQueryContext.$default$text2SQLType();
    }

    public ChatQueryContext(String queryText, Set<Long> dataSetIds, Map<Long, List<Long>> modelIdToDataSetIds, User user, boolean saveAnswer, Text2SQLType text2SQLType, QueryFilters queryFilters, List<SemanticQuery> candidateQueries, SchemaMapInfo mapInfo, MapModeEnum mapModeEnum, SemanticSchema semanticSchema, ChatWorkflowState chatWorkflowState, QueryDataType queryDataType, ChatModelConfig modelConfig, PromptConfig promptConfig, List<SqlExemplar> dynamicExemplars, SemanticParseInfo contextParseInfo) {
        this.queryText = queryText;
        this.dataSetIds = dataSetIds;
        this.modelIdToDataSetIds = modelIdToDataSetIds;
        this.user = user;
        this.saveAnswer = saveAnswer;
        this.text2SQLType = text2SQLType;
        this.queryFilters = queryFilters;
        this.candidateQueries = candidateQueries;
        this.mapInfo = mapInfo;
        this.mapModeEnum = mapModeEnum;
        this.semanticSchema = semanticSchema;
        this.chatWorkflowState = chatWorkflowState;
        this.queryDataType = queryDataType;
        this.modelConfig = modelConfig;
        this.promptConfig = promptConfig;
        this.dynamicExemplars = dynamicExemplars;
        this.contextParseInfo = contextParseInfo;
    }

    public static class ChatQueryContextBuilder {
        private String queryText;
        private Set<Long> dataSetIds;
        private Map<Long, List<Long>> modelIdToDataSetIds;
        private User user;
        private boolean saveAnswer;
        private boolean text2SQLType$set;
        private Text2SQLType text2SQLType$value;
        private QueryFilters queryFilters;
        private List<SemanticQuery> candidateQueries;
        private SchemaMapInfo mapInfo;
        private MapModeEnum mapModeEnum;
        private SemanticSchema semanticSchema;
        private ChatWorkflowState chatWorkflowState;
        private QueryDataType queryDataType;
        private ChatModelConfig modelConfig;
        private PromptConfig promptConfig;
        private List<SqlExemplar> dynamicExemplars;
        private SemanticParseInfo contextParseInfo;

        ChatQueryContextBuilder() {
        }

        public ChatQueryContextBuilder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public ChatQueryContextBuilder dataSetIds(Set<Long> dataSetIds) {
            this.dataSetIds = dataSetIds;
            return this;
        }

        public ChatQueryContextBuilder modelIdToDataSetIds(Map<Long, List<Long>> modelIdToDataSetIds) {
            this.modelIdToDataSetIds = modelIdToDataSetIds;
            return this;
        }

        public ChatQueryContextBuilder user(User user) {
            this.user = user;
            return this;
        }

        public ChatQueryContextBuilder saveAnswer(boolean saveAnswer) {
            this.saveAnswer = saveAnswer;
            return this;
        }

        public ChatQueryContextBuilder text2SQLType(Text2SQLType text2SQLType) {
            this.text2SQLType$value = text2SQLType;
            this.text2SQLType$set = true;
            return this;
        }

        public ChatQueryContextBuilder queryFilters(QueryFilters queryFilters) {
            this.queryFilters = queryFilters;
            return this;
        }

        public ChatQueryContextBuilder candidateQueries(List<SemanticQuery> candidateQueries) {
            this.candidateQueries = candidateQueries;
            return this;
        }

        public ChatQueryContextBuilder mapInfo(SchemaMapInfo mapInfo) {
            this.mapInfo = mapInfo;
            return this;
        }

        public ChatQueryContextBuilder mapModeEnum(MapModeEnum mapModeEnum) {
            this.mapModeEnum = mapModeEnum;
            return this;
        }

        @JsonIgnore
        public ChatQueryContextBuilder semanticSchema(SemanticSchema semanticSchema) {
            this.semanticSchema = semanticSchema;
            return this;
        }

        @JsonIgnore
        public ChatQueryContextBuilder chatWorkflowState(ChatWorkflowState chatWorkflowState) {
            this.chatWorkflowState = chatWorkflowState;
            return this;
        }

        public ChatQueryContextBuilder queryDataType(QueryDataType queryDataType) {
            this.queryDataType = queryDataType;
            return this;
        }

        public ChatQueryContextBuilder modelConfig(ChatModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        public ChatQueryContextBuilder promptConfig(PromptConfig promptConfig) {
            this.promptConfig = promptConfig;
            return this;
        }

        public ChatQueryContextBuilder dynamicExemplars(List<SqlExemplar> dynamicExemplars) {
            this.dynamicExemplars = dynamicExemplars;
            return this;
        }

        public ChatQueryContextBuilder contextParseInfo(SemanticParseInfo contextParseInfo) {
            this.contextParseInfo = contextParseInfo;
            return this;
        }

        public ChatQueryContext build() {
            Text2SQLType text2SQLType$value = this.text2SQLType$value;
            if (!this.text2SQLType$set) {
                text2SQLType$value = ChatQueryContext.$default$text2SQLType();
            }
            return new ChatQueryContext(this.queryText, this.dataSetIds, this.modelIdToDataSetIds, this.user, this.saveAnswer, text2SQLType$value, this.queryFilters, this.candidateQueries, this.mapInfo, this.mapModeEnum, this.semanticSchema, this.chatWorkflowState, this.queryDataType, this.modelConfig, this.promptConfig, this.dynamicExemplars, this.contextParseInfo);
        }

        public String toString() {
            return "ChatQueryContext.ChatQueryContextBuilder(queryText=" + this.queryText + ", dataSetIds=" + this.dataSetIds + ", modelIdToDataSetIds=" + this.modelIdToDataSetIds + ", user=" + this.user + ", saveAnswer=" + this.saveAnswer + ", text2SQLType$value=" + this.text2SQLType$value + ", queryFilters=" + this.queryFilters + ", candidateQueries=" + this.candidateQueries + ", mapInfo=" + this.mapInfo + ", mapModeEnum=" + this.mapModeEnum + ", semanticSchema=" + this.semanticSchema + ", chatWorkflowState=" + this.chatWorkflowState + ", queryDataType=" + this.queryDataType + ", modelConfig=" + this.modelConfig + ", promptConfig=" + this.promptConfig + ", dynamicExemplars=" + this.dynamicExemplars + ", contextParseInfo=" + this.contextParseInfo + ")";
        }
    }
}

