/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.pojo.enums.DatePeriodEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TimeMode;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.TimeDefaultConfig;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class S2SqlDateHelper {
    public static String getReferenceDate(ChatQueryContext chatQueryContext, Long dataSetId) {
        String defaultDate = DateUtils.getBeforeDate((int)0);
        if (Objects.isNull(dataSetId)) {
            return defaultDate;
        }
        DataSetSchema dataSetSchema = (DataSetSchema)chatQueryContext.getSemanticSchema().getDataSetSchemaMap().get(dataSetId);
        if (dataSetSchema == null || dataSetSchema.getTagTypeTimeDefaultConfig() == null) {
            return defaultDate;
        }
        TimeDefaultConfig tagTypeTimeDefaultConfig = dataSetSchema.getTagTypeTimeDefaultConfig();
        return (String)S2SqlDateHelper.getDefaultDate(defaultDate, tagTypeTimeDefaultConfig).getLeft();
    }

    public static Pair<String, String> getStartEndDate(ChatQueryContext chatQueryContext, Long dataSetId, QueryType queryType) {
        String defaultDate = DateUtils.getBeforeDate((int)0);
        if (Objects.isNull(dataSetId)) {
            return Pair.of((Object)defaultDate, (Object)defaultDate);
        }
        DataSetSchema dataSetSchema = (DataSetSchema)chatQueryContext.getSemanticSchema().getDataSetSchemaMap().get(dataSetId);
        if (dataSetSchema == null) {
            return Pair.of((Object)defaultDate, (Object)defaultDate);
        }
        TimeDefaultConfig defaultConfig = dataSetSchema.getMetricTypeTimeDefaultConfig();
        if (QueryType.DETAIL.equals((Object)queryType)) {
            defaultConfig = dataSetSchema.getTagTypeTimeDefaultConfig();
        }
        return S2SqlDateHelper.getDefaultDate(defaultDate, defaultConfig);
    }

    private static Pair<String, String> getDefaultDate(String defaultDate, TimeDefaultConfig defaultConfig) {
        if (Objects.isNull(defaultConfig)) {
            return Pair.of(null, null);
        }
        Integer unit = defaultConfig.getUnit();
        String period = defaultConfig.getPeriod();
        TimeMode timeMode = defaultConfig.getTimeMode();
        if (Objects.nonNull(unit)) {
            if (unit < 0) {
                return Pair.of(null, null);
            }
            DatePeriodEnum datePeriodEnum = DatePeriodEnum.get((String)period);
            String startDate = DateUtils.getBeforeDate((int)unit, (DatePeriodEnum)datePeriodEnum);
            String endDate = DateUtils.getBeforeDate((int)1, (DatePeriodEnum)datePeriodEnum);
            if (unit == 0) {
                endDate = startDate;
            }
            if (TimeMode.LAST.equals((Object)timeMode)) {
                endDate = startDate;
            }
            return Pair.of((Object)startDate, (Object)endDate);
        }
        return Pair.of((Object)defaultDate, (Object)defaultDate);
    }
}

