/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlRemoveHelper;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class SelectCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(SelectCorrector.class);
    public static final String ADDITIONAL_INFORMATION = "s2.corrector.additional.information";

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectedS2SQL();
        List aggregateFields = SqlSelectHelper.getAggregateFields((String)correctS2SQL);
        List selectFields = SqlSelectHelper.getSelectFields((String)correctS2SQL);
        if (!CollectionUtils.isEmpty((Collection)aggregateFields) && !CollectionUtils.isEmpty((Collection)selectFields) && aggregateFields.size() == selectFields.size()) {
            return;
        }
        correctS2SQL = this.addFieldsToSelect(chatQueryContext, semanticParseInfo, correctS2SQL);
        String querySql = SqlReplaceHelper.dealAliasToOrderBy((String)correctS2SQL);
        semanticParseInfo.getSqlInfo().setCorrectedS2SQL(querySql);
    }

    protected String addFieldsToSelect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo, String correctS2SQL) {
        correctS2SQL = this.addTagDefaultFields(chatQueryContext, semanticParseInfo, correctS2SQL);
        HashSet selectFields = new HashSet(SqlSelectHelper.getSelectFields((String)correctS2SQL));
        HashSet needAddFields = new HashSet(SqlSelectHelper.getGroupByFields((String)correctS2SQL));
        Environment environment = (Environment)ContextUtils.getBean(Environment.class);
        String correctorAdditionalInfo = environment.getProperty(ADDITIONAL_INFORMATION);
        if (StringUtils.isNotBlank((CharSequence)correctorAdditionalInfo) && Boolean.parseBoolean(correctorAdditionalInfo)) {
            needAddFields.addAll(SqlSelectHelper.getOrderByFields((String)correctS2SQL));
        }
        if (CollectionUtils.isEmpty(selectFields) || CollectionUtils.isEmpty(needAddFields)) {
            return correctS2SQL;
        }
        needAddFields.removeAll(selectFields);
        String addFieldsToSelectSql = SqlAddHelper.addFieldsToSelect((String)correctS2SQL, new ArrayList(needAddFields));
        semanticParseInfo.getSqlInfo().setCorrectedS2SQL(addFieldsToSelectSql);
        return addFieldsToSelectSql;
    }

    private String addTagDefaultFields(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo, String correctS2SQL) {
        boolean hasAsterisk = SqlSelectFunctionHelper.hasAsterisk((String)correctS2SQL);
        if (!hasAsterisk || !QueryType.DETAIL.equals((Object)semanticParseInfo.getQueryType())) {
            return correctS2SQL;
        }
        Long dataSetId = semanticParseInfo.getDataSetId();
        DataSetSchema dataSetSchema = (DataSetSchema)chatQueryContext.getSemanticSchema().getDataSetSchemaMap().get(dataSetId);
        HashSet needAddDefaultFields = new HashSet();
        if (Objects.nonNull(dataSetSchema)) {
            if (!CollectionUtils.isEmpty((Collection)dataSetSchema.getTagDefaultMetrics())) {
                Set metrics = dataSetSchema.getTagDefaultMetrics().stream().map(schemaElement -> schemaElement.getName()).collect(Collectors.toSet());
                needAddDefaultFields.addAll(metrics);
            }
            if (!CollectionUtils.isEmpty((Collection)dataSetSchema.getTagDefaultDimensions())) {
                Set dimensions = dataSetSchema.getTagDefaultDimensions().stream().map(schemaElement -> schemaElement.getName()).collect(Collectors.toSet());
                needAddDefaultFields.addAll(dimensions);
            }
        }
        if (!CollectionUtils.isEmpty(needAddDefaultFields)) {
            correctS2SQL = SqlRemoveHelper.removeAsteriskAndAddFields((String)correctS2SQL, needAddDefaultFields);
        }
        return correctS2SQL;
    }
}

