/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.corrector;

import com.tencent.supersonic.common.jsqlparser.SqlAddHelper;
import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaValueMap;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.BaseSemanticCorrector;
import com.tencent.supersonic.headless.chat.utils.QueryFilterParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WhereCorrector
extends BaseSemanticCorrector {
    private static final Logger log = LoggerFactory.getLogger(WhereCorrector.class);

    @Override
    public void doCorrect(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        this.addQueryFilter(chatQueryContext, semanticParseInfo);
        this.updateFieldValueByTechName(chatQueryContext, semanticParseInfo);
    }

    protected void addQueryFilter(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        String queryFilter = this.getQueryFilter(chatQueryContext.getQueryFilters());
        String correctS2SQL = semanticParseInfo.getSqlInfo().getCorrectedS2SQL();
        if (StringUtils.isNotEmpty((CharSequence)queryFilter)) {
            log.info("add queryFilter to correctS2SQL :{}", (Object)queryFilter);
            Expression expression = null;
            try {
                expression = CCJSqlParserUtil.parseCondExpression((String)queryFilter);
            }
            catch (JSQLParserException e) {
                log.error("parseCondExpression", (Throwable)e);
            }
            correctS2SQL = SqlAddHelper.addWhere((String)correctS2SQL, (Expression)expression);
            semanticParseInfo.getSqlInfo().setCorrectedS2SQL(correctS2SQL);
        }
    }

    private String getQueryFilter(QueryFilters queryFilters) {
        if (Objects.isNull(queryFilters) || CollectionUtils.isEmpty((Collection)queryFilters.getFilters())) {
            return null;
        }
        return QueryFilterParser.parse(queryFilters);
    }

    private void updateFieldValueByTechName(ChatQueryContext chatQueryContext, SemanticParseInfo semanticParseInfo) {
        Long dataSetId;
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        List dimensions = semanticSchema.getDimensions(dataSetId = semanticParseInfo.getDataSetId());
        if (CollectionUtils.isEmpty((Collection)dimensions)) {
            return;
        }
        Map<String, Map<String, String>> aliasAndBizNameToTechName = this.getAliasAndBizNameToTechName(dimensions);
        String correctS2SQL = SqlReplaceHelper.replaceValue((String)semanticParseInfo.getSqlInfo().getCorrectedS2SQL(), aliasAndBizNameToTechName);
        semanticParseInfo.getSqlInfo().setCorrectedS2SQL(correctS2SQL);
    }

    private Map<String, Map<String, String>> getAliasAndBizNameToTechName(List<SchemaElement> dimensions) {
        if (CollectionUtils.isEmpty(dimensions)) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (SchemaElement dimension : dimensions) {
            if (Objects.isNull(dimension) || StringUtils.isEmpty((CharSequence)dimension.getName()) || CollectionUtils.isEmpty((Collection)dimension.getSchemaValueMaps())) continue;
            String name = dimension.getName();
            HashMap<String, String> aliasAndBizNameToTechName = new HashMap<String, String>();
            for (SchemaValueMap valueMap : dimension.getSchemaValueMaps()) {
                if (Objects.isNull(valueMap) || StringUtils.isEmpty((CharSequence)valueMap.getTechName())) continue;
                if (StringUtils.isNotEmpty((CharSequence)valueMap.getBizName())) {
                    aliasAndBizNameToTechName.put(valueMap.getBizName(), valueMap.getTechName());
                }
                if (CollectionUtils.isEmpty((Collection)valueMap.getAlias())) continue;
                valueMap.getAlias().stream().forEach(alias -> {
                    if (StringUtils.isNotEmpty((CharSequence)alias)) {
                        aliasAndBizNameToTechName.put((String)alias, valueMap.getTechName());
                    }
                });
            }
            if (CollectionUtils.isEmpty(aliasAndBizNameToTechName)) continue;
            result.put(name, aliasAndBizNameToTechName);
        }
        return result;
    }
}

