/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge;

import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.SearchService;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBaseService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBaseService.class);

    public void updateSemanticKnowledge(List<DictWord> natures) {
        List prefixes = natures.stream().filter(entry -> !entry.getNatureWithFrequency().contains(DictWordType.SUFFIX.getType())).collect(Collectors.toList());
        for (DictWord nature : prefixes) {
            HanlpHelper.addToCustomDictionary(nature);
        }
        List<DictWord> suffixes = natures.stream().filter(entry -> entry.getNatureWithFrequency().contains(DictWordType.SUFFIX.getType())).collect(Collectors.toList());
        SearchService.loadSuffix(suffixes);
    }

    public void reloadAllData(List<DictWord> natures) {
        try {
            HanlpHelper.reloadCustomDictionary();
        }
        catch (Exception e) {
            log.error("reloadCustomDictionary error", (Throwable)e);
        }
        this.updateOnlineKnowledge(natures);
    }

    public void updateOnlineKnowledge(List<DictWord> natures) {
        try {
            this.updateSemanticKnowledge(natures);
        }
        catch (Exception e) {
            log.error("updateSemanticKnowledge error", (Throwable)e);
        }
    }

    public List<S2Term> getTerms(String text, Map<Long, List<Long>> modelIdToDataSetIds) {
        return HanlpHelper.getTerms(text, modelIdToDataSetIds);
    }

    public List<HanlpMapResult> prefixSearch(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        return this.prefixSearchByModel(key, limit, modelIdToDataSetIds, detectDataSetIds);
    }

    public List<HanlpMapResult> prefixSearchByModel(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        return SearchService.prefixSearch(key, limit, modelIdToDataSetIds, detectDataSetIds);
    }

    public List<HanlpMapResult> suffixSearch(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        return this.suffixSearchByModel(key, limit, modelIdToDataSetIds, detectDataSetIds);
    }

    public List<HanlpMapResult> suffixSearchByModel(String key, int limit, Map<Long, List<Long>> modelIdToDataSetIds, Set<Long> detectDataSetIds) {
        return SearchService.suffixSearch(key, limit, modelIdToDataSetIds, detectDataSetIds);
    }
}

