/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import com.tencent.supersonic.headless.chat.knowledge.DictionaryAttributeUtil;
import com.tencent.supersonic.headless.chat.knowledge.SearchService;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToIntFunction;

public class MultiCustomDictionary
extends DynamicCustomDictionary {
    public static int MAX_SIZE = 10;
    public static Boolean removeDuplicates = true;
    public static ConcurrentHashMap<String, PriorityQueue<Term>> NATURE_TO_VALUES = new ConcurrentHashMap();
    private static boolean addToSuggesterTrie = true;

    public MultiCustomDictionary() {
        this(HanLP.Config.CustomDictionaryPath);
    }

    public MultiCustomDictionary(String ... path) {
        super(path);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean load(String path, Nature defaultNature, TreeMap<String, CoreDictionary.Attribute> map, LinkedHashSet<Nature> customNatureCollector, boolean addToSuggeterTrie) {
        try {
            splitter = "\\s";
            if (path.endsWith(".csv")) {
                splitter = ",";
            }
            br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream((String)path), "UTF-8"));
            firstLine = true;
            block2: while (true) {
                if ((line = br.readLine()) == null) {
                    br.close();
                    return true;
                }
                if (firstLine) {
                    line = IOUtil.removeUTF8BOM((String)line);
                    firstLine = false;
                }
                if ((param = line.split(splitter))[0].length() == 0) continue;
                if (HanLP.Config.Normalization) {
                    param[0] = CharTable.convert((String)param[0]);
                }
                natureCount = (param.length - 1) / 2;
                isLetters = MultiCustomDictionary.isLetters(param[0]);
                original = null;
                word = MultiCustomDictionary.getWordBySpace(param[0]);
                if (isLetters) {
                    original = word;
                    word = word.toLowerCase();
                }
                if (natureCount == 0) {
                    attribute = new CoreDictionary.Attribute(defaultNature);
                } else {
                    attribute = new CoreDictionary.Attribute(natureCount);
                    for (i = 0; i < natureCount; ++i) {
                        attribute.nature[i] = LexiconUtility.convertStringToNature((String)param[1 + 2 * i], customNatureCollector);
                        attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                        attribute.originals[i] = original;
                        attribute.totalFrequency += attribute.frequency[i];
                    }
                }
                if (MultiCustomDictionary.removeDuplicates.booleanValue() && map.containsKey(word)) {
                    attribute = DictionaryAttributeUtil.getAttribute(map.get(word), attribute);
                }
                map.put(word, attribute);
                if (addToSuggeterTrie) {
                    SearchService.put(word, attribute);
                }
                i = 0;
                while (true) {
                    if (i < attribute.nature.length) ** break;
                    continue block2;
                    nature = attribute.nature[i];
                    priorityQueue = MultiCustomDictionary.NATURE_TO_VALUES.get(nature.toString());
                    if (Objects.isNull(priorityQueue)) {
                        priorityQueue = new PriorityQueue<Term>(MultiCustomDictionary.MAX_SIZE, Comparator.comparingInt((ToIntFunction<Term>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getFrequency(), (Lcom/hankcs/hanlp/seg/common/Term;)I)()).reversed());
                        MultiCustomDictionary.NATURE_TO_VALUES.put(nature.toString(), priorityQueue);
                    }
                    term = new Term(word, nature);
                    term.setFrequency(attribute.frequency[i]);
                    if (!priorityQueue.contains(term) && priorityQueue.size() < MultiCustomDictionary.MAX_SIZE) {
                        priorityQueue.add(term);
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception var12) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + var12);
            return false;
        }
    }

    public boolean load(String ... path) {
        this.path = path;
        long start = System.currentTimeMillis();
        if (!this.loadMainDictionary(path[0])) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + Arrays.toString(path) + "\u52a0\u8f7d\u5931\u8d25");
            return false;
        }
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + this.dat.size() + "\u4e2a\u8bcd\u6761\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        this.path = path;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean loadMainDictionary(String mainPath, String[] path, DoubleArrayTrie<CoreDictionary.Attribute> dat, boolean isCache, boolean addToSuggestTrie) {
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + mainPath);
        if (MultiCustomDictionary.loadDat(mainPath, dat)) {
            return true;
        }
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        LinkedHashSet<Nature> customNatureCollector = new LinkedHashSet<Nature>();
        try {
            for (String string : path) {
                void var10_16;
                Nature defaultNature = Nature.n;
                File file = new File(string);
                String fileName = file.getName();
                int cut = fileName.lastIndexOf(32);
                if (cut > 0) {
                    String nature = fileName.substring(cut + 1);
                    String string2 = file.getParent() + File.separator + fileName.substring(0, cut);
                    try {
                        defaultNature = LexiconUtility.convertStringToNature((String)nature, customNatureCollector);
                    }
                    catch (Exception var16) {
                        Predefine.logger.severe("\u914d\u7f6e\u6587\u4ef6\u3010" + string2 + "\u3011\u5199\u9519\u4e86\uff01" + var16);
                        continue;
                    }
                }
                Predefine.logger.info("\u4ee5\u9ed8\u8ba4\u8bcd\u6027[" + defaultNature + "]\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178" + (String)var10_16 + "\u4e2d\u2026\u2026");
                boolean success = MultiCustomDictionary.load((String)var10_16, defaultNature, map, customNatureCollector, addToSuggestTrie);
                if (success) continue;
                Predefine.logger.warning("\u5931\u8d25\uff1a" + (String)var10_16);
            }
            if (map.size() == 0) {
                Predefine.logger.warning("\u6ca1\u6709\u52a0\u8f7d\u5230\u4efb\u4f55\u8bcd\u6761");
                map.put("\u672a##\u5b83", null);
            }
            Predefine.logger.info("\u6b63\u5728\u6784\u5efaDoubleArrayTrie\u2026\u2026");
            dat.build(map);
            if (addToSuggestTrie) {
                // empty if block
            }
            if (isCache) {
                Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u8bcd\u5178\u4e3adat\u6587\u4ef6\u2026\u2026");
                LinkedList<CoreDictionary.Attribute> attributeList = new LinkedList<CoreDictionary.Attribute>();
                for (Map.Entry entry : map.entrySet()) {
                    attributeList.add((CoreDictionary.Attribute)entry.getValue());
                }
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(IOUtil.newOutputStream((String)(mainPath + ".bin"))));
                if (customNatureCollector.isEmpty()) {
                    for (int i = Nature.begin.ordinal() + 1; i < Nature.values().length; ++i) {
                        Nature nature = Nature.values()[i];
                        if (!Objects.nonNull(nature)) continue;
                        customNatureCollector.add(nature);
                    }
                }
                IOUtil.writeCustomNature((DataOutputStream)out, customNatureCollector);
                out.writeInt(attributeList.size());
                for (CoreDictionary.Attribute attribute : attributeList) {
                    attribute.save(out);
                }
                dat.save(out);
                out.close();
            }
        }
        catch (FileNotFoundException var17) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u4e0d\u5b58\u5728\uff01" + var17);
            return false;
        }
        catch (IOException var18) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u8bfb\u53d6\u9519\u8bef\uff01" + var18);
            return false;
        }
        catch (Exception var19) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u7f13\u5b58\u5931\u8d25\uff01\n" + TextUtility.exceptionToString((Exception)var19));
        }
        return true;
    }

    public boolean loadMainDictionary(String mainPath) {
        return MultiCustomDictionary.loadMainDictionary(mainPath, this.path, (DoubleArrayTrie<CoreDictionary.Attribute>)this.dat, true, addToSuggesterTrie);
    }

    public static boolean loadDat(String path, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        return MultiCustomDictionary.loadDat(path, HanLP.Config.CustomDictionaryPath, dat);
    }

    public static boolean loadDat(String path, String[] customDicPath, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        try {
            if (HanLP.Config.CustomDictionaryAutoRefreshCache && DynamicCustomDictionary.isDicNeedUpdate((String)path, (String[])customDicPath)) {
                return false;
            }
            ByteArray byteArray = ByteArray.createByteArray((String)(path + ".bin"));
            if (byteArray == null) {
                return false;
            }
            int size = byteArray.nextInt();
            if (size < 0) {
                while (true) {
                    if (++size > 0) {
                        size = byteArray.nextInt();
                        break;
                    }
                    Nature.create((String)byteArray.nextString());
                }
            }
            Object[] attributes = new CoreDictionary.Attribute[size];
            Nature[] natureIndexArray = Nature.values();
            for (int i = 0; i < size; ++i) {
                int currentTotalFrequency = byteArray.nextInt();
                int length = byteArray.nextInt();
                attributes[i] = new CoreDictionary.Attribute(length);
                ((CoreDictionary.Attribute)attributes[i]).totalFrequency = currentTotalFrequency;
                for (int j = 0; j < length; ++j) {
                    ((CoreDictionary.Attribute)attributes[i]).nature[j] = natureIndexArray[byteArray.nextInt()];
                    ((CoreDictionary.Attribute)attributes[i]).frequency[j] = byteArray.nextInt();
                }
            }
            return dat.load(byteArray, attributes);
        }
        catch (Exception var11) {
            Predefine.logger.warning("\u8bfb\u53d6\u5931\u8d25\uff0c\u95ee\u9898\u53d1\u751f\u5728" + TextUtility.exceptionToString((Exception)var11));
            return false;
        }
    }

    public static boolean isLetters(String str) {
        char[] chars = str.toCharArray();
        if (chars.length <= 1) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < 'A' || chars[i] > 'Z') continue;
            return true;
        }
        return false;
    }

    public static boolean isLowerLetter(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < 'a' || chars[i] > 'z') continue;
            return true;
        }
        return false;
    }

    public static String getWordBySpace(String word) {
        if (word.contains("#")) {
            return word.replace("#", " ");
        }
        return word;
    }

    public boolean reload() {
        if (this.path != null && this.path.length != 0) {
            IOUtil.deleteFile((String)(this.path[0] + ".bin"));
            Boolean loadCacheOk = MultiCustomDictionary.loadDat(this.path[0], this.path, (DoubleArrayTrie<CoreDictionary.Attribute>)this.dat);
            if (!loadCacheOk.booleanValue()) {
                return MultiCustomDictionary.loadMainDictionary(this.path[0], this.path, (DoubleArrayTrie<CoreDictionary.Attribute>)this.dat, true, addToSuggesterTrie);
            }
        }
        return false;
    }

    public synchronized boolean insert(String word, String natureWithFrequency) {
        if (word == null) {
            return false;
        }
        if (HanLP.Config.Normalization) {
            word = CharTable.convert((String)word);
        }
        CoreDictionary.Attribute att = natureWithFrequency == null ? new CoreDictionary.Attribute(Nature.nz, 1) : CoreDictionary.Attribute.create((String)natureWithFrequency);
        boolean isLetters = MultiCustomDictionary.isLetters(word);
        word = MultiCustomDictionary.getWordBySpace(word);
        String original = null;
        if (isLetters) {
            original = word;
            word = word.toLowerCase();
        }
        if (att == null) {
            return false;
        }
        if (this.dat.containsKey(word)) {
            att.setOriginals(original);
            att = DictionaryAttributeUtil.getAttribute((CoreDictionary.Attribute)this.dat.get(word), att);
            this.dat.set(word, (Object)att);
        } else {
            if (this.trie == null) {
                this.trie = new BinTrie();
            }
            att.setOriginals(original);
            if (this.trie.containsKey(word)) {
                att = DictionaryAttributeUtil.getAttribute((CoreDictionary.Attribute)this.trie.get(word), att);
            }
            this.trie.put(word, (Object)att);
        }
        if (addToSuggesterTrie) {
            SearchService.put(word, att);
        }
        return true;
    }
}

