/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.builder;

import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWordBuilder {
    private static final Logger log = LoggerFactory.getLogger(BaseWordBuilder.class);
    public static final Long DEFAULT_FREQUENCY = 100000L;

    public List<DictWord> getDictWords(List<SchemaElement> schemaElements) {
        ArrayList<DictWord> dictWords = new ArrayList();
        try {
            dictWords = this.getDictWordsWithException(schemaElements);
        }
        catch (Exception e) {
            log.error("getWordNatureList error,", (Throwable)e);
        }
        return dictWords;
    }

    protected List<DictWord> getDictWordsWithException(List<SchemaElement> schemaElements) {
        ArrayList<DictWord> dictWords = new ArrayList<DictWord>();
        for (SchemaElement schemaElement : schemaElements) {
            dictWords.addAll(this.doGet(schemaElement.getName(), schemaElement));
        }
        return dictWords;
    }

    protected abstract List<DictWord> doGet(String var1, SchemaElement var2);
}

