/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.builder;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordWithAliasBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MetricWordBuilder
extends BaseWordWithAliasBuilder {
    @Override
    public List<DictWord> doGet(String word, SchemaElement schemaElement) {
        ArrayList result = Lists.newArrayList();
        result.add(this.getOneWordNature(word, schemaElement, false));
        result.addAll(this.getOneWordNatureAlias(schemaElement, false));
        String reverseWord = StringUtils.reverse((String)word);
        if (!word.equalsIgnoreCase(reverseWord)) {
            result.add(this.getOneWordNature(reverseWord, schemaElement, true));
        }
        return result;
    }

    @Override
    public DictWord getOneWordNature(String word, SchemaElement schemaElement, boolean isSuffix) {
        DictWord dictWord = new DictWord();
        dictWord.setWord(word);
        Long modelId = schemaElement.getModel();
        String nature = "_" + modelId + "_" + schemaElement.getId() + DictWordType.METRIC.getType();
        if (isSuffix) {
            nature = "_" + modelId + "_" + schemaElement.getId() + DictWordType.SUFFIX.getType() + DictWordType.METRIC.getType();
        }
        dictWord.setNatureWithFrequency(String.format("%s " + DEFAULT_FREQUENCY, nature));
        return dictWord;
    }
}

