/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.builder;

import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.DimensionWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.EntityWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.MetricWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.ModelWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.TermWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.builder.ValueWordBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WordBuilderFactory {
    private static Map<DictWordType, BaseWordBuilder> wordNatures = new ConcurrentHashMap<DictWordType, BaseWordBuilder>();

    public static BaseWordBuilder get(DictWordType strategyType) {
        return wordNatures.get(strategyType);
    }

    static {
        wordNatures.put(DictWordType.DIMENSION, new DimensionWordBuilder());
        wordNatures.put(DictWordType.METRIC, new MetricWordBuilder());
        wordNatures.put(DictWordType.DATASET, new ModelWordBuilder());
        wordNatures.put(DictWordType.ENTITY, new EntityWordBuilder());
        wordNatures.put(DictWordType.VALUE, new ValueWordBuilder());
        wordNatures.put(DictWordType.TERM, new TermWordBuilder());
    }
}

