/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.file;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.headless.api.pojo.request.DictValueReq;
import com.tencent.supersonic.headless.api.pojo.response.DictValueResp;
import com.tencent.supersonic.headless.chat.knowledge.file.FileHandler;
import com.tencent.supersonic.headless.chat.knowledge.file.LocalFileConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FileHandlerImpl
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(FileHandlerImpl.class);
    public static final String FILE_SPILT = File.separator;
    private final LocalFileConfig localFileConfig;

    public FileHandlerImpl(LocalFileConfig localFileConfig) {
        this.localFileConfig = localFileConfig;
    }

    @Override
    public void backupFile(String fileName) {
        String dictDirectoryBackup = this.localFileConfig.getDictDirectoryBackup();
        if (!this.existPath(dictDirectoryBackup).booleanValue()) {
            this.createDir(dictDirectoryBackup);
        }
        String source = this.localFileConfig.getDictDirectoryLatest() + FILE_SPILT + fileName;
        String target = dictDirectoryBackup + FILE_SPILT + fileName;
        Path sourcePath = Paths.get(source, new String[0]);
        Path targetPath = Paths.get(target, new String[0]);
        try {
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            log.info("backupFile successfully! path:{}", (Object)targetPath.toAbsolutePath());
        }
        catch (IOException e) {
            log.info("Failed to copy file: " + e.getMessage());
        }
    }

    @Override
    public void createDir(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            log.info("Directory created successfully!");
        }
        catch (IOException e) {
            log.info("Failed to create directory: " + e.getMessage());
        }
    }

    @Override
    public void deleteFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            Files.delete(path);
            log.info("File:{} deleted successfully!", (Object)this.getAbsolutePath(filePath));
        }
        catch (IOException e) {
            log.warn("Failed to delete file:{}, e:", (Object)this.getAbsolutePath(filePath), (Object)e);
        }
    }

    @Override
    public PageInfo<DictValueResp> queryDictValue(String fileName, DictValueReq dictValueReq) {
        PageInfo dictValueRespPageInfo = new PageInfo();
        String filePath = this.localFileConfig.getDictDirectoryLatest() + FILE_SPILT + fileName;
        Long fileLineNum = this.getFileLineNum(filePath);
        Integer startLine = (dictValueReq.getCurrent() - 1) * dictValueReq.getPageSize() + 1;
        Integer endLine = Integer.valueOf("" + Math.min((long)(dictValueReq.getCurrent() * dictValueReq.getPageSize()), fileLineNum));
        List<DictValueResp> dictValueRespList = this.getFileData(filePath, startLine, endLine);
        dictValueRespPageInfo.setPageSize(dictValueReq.getPageSize().intValue());
        dictValueRespPageInfo.setPageNum(dictValueReq.getCurrent().intValue());
        dictValueRespPageInfo.setTotal(fileLineNum.longValue());
        dictValueRespPageInfo.setList(dictValueRespList);
        dictValueRespPageInfo.setHasNextPage((long)endLine.intValue() < fileLineNum);
        dictValueRespPageInfo.setHasPreviousPage(startLine > 0);
        return dictValueRespPageInfo;
    }

    @Override
    public String queryDictFilePath(String fileName) {
        String path = this.localFileConfig.getDictDirectoryLatest() + FILE_SPILT + fileName;
        if (this.existPath(path).booleanValue()) {
            return path;
        }
        log.info("dict file:{} is not exist", (Object)path);
        return null;
    }

    private List<DictValueResp> getFileData(String filePath, Integer startLine, Integer endLine) {
        List<Object> fileData = new ArrayList<DictValueResp>();
        try (Stream<String> lines = Files.lines(Paths.get(filePath, new String[0]));){
            fileData = lines.skip(startLine - 1).limit(endLine - startLine + 1).map(lineStr -> this.convert2Resp((String)lineStr)).filter(line -> Objects.nonNull(line)).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.warn("[getFileData] e:{}", (Throwable)e);
        }
        return fileData;
    }

    private DictValueResp convert2Resp(String lineStr) {
        String[] itemArray;
        DictValueResp dictValueResp = new DictValueResp();
        if (StringUtils.isNotEmpty((CharSequence)lineStr) && Objects.nonNull(itemArray = lineStr.split("\\s+")) && itemArray.length >= 3) {
            dictValueResp.setValue(itemArray[0].replace("#", " "));
            dictValueResp.setNature(itemArray[1]);
            dictValueResp.setFrequency(Long.valueOf(Long.parseLong(itemArray[2])));
        }
        return dictValueResp;
    }

    private Long getFileLineNum(String filePath) {
        Long l;
        block8: {
            Stream<String> lines = Files.lines(Paths.get(filePath, new String[0]));
            try {
                Long lineCount;
                l = lineCount = Long.valueOf(lines.count());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0L;
                }
            }
            lines.close();
        }
        return l;
    }

    @Override
    public Boolean existPath(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            log.info("path:{} exists!", (Object)this.getAbsolutePath(pathStr));
            return true;
        }
        log.info("path:{} not exists!", (Object)this.getAbsolutePath(pathStr));
        return false;
    }

    @Override
    public void writeFile(List<String> lines, String fileName, Boolean append) {
        String filePath;
        if (CollectionUtils.isEmpty(lines)) {
            log.info("lines is empty");
            return;
        }
        String dictDirectoryLatest = this.localFileConfig.getDictDirectoryLatest();
        if (!this.existPath(dictDirectoryLatest).booleanValue()) {
            this.createDir(dictDirectoryLatest);
        }
        if (this.existPath(filePath = dictDirectoryLatest + FILE_SPILT + fileName).booleanValue()) {
            this.backupFile(fileName);
        }
        try (BufferedWriter writer = this.getWriter(filePath, append);){
            if (!CollectionUtils.isEmpty(lines)) {
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            log.info("File:{} written successfully!", (Object)this.getAbsolutePath(filePath));
        }
        catch (IOException e) {
            log.info("Failed to write file:{}, e:", (Object)this.getAbsolutePath(filePath), (Object)e);
        }
    }

    public String getAbsolutePath(String path) {
        return Paths.get(path, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public String getDictRootPath() {
        return Paths.get(this.localFileConfig.getDictDirectoryLatest(), new String[0]).toAbsolutePath().toString();
    }

    @Override
    public Boolean deleteDictFile(String fileName) {
        this.backupFile(fileName);
        this.deleteFile(this.localFileConfig.getDictDirectoryLatest() + FILE_SPILT + fileName);
        return true;
    }

    private BufferedWriter getWriter(String filePath, Boolean append) throws IOException {
        if (append.booleanValue()) {
            return Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        return Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

