/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.file;

import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LocalFileConfig {
    private static final Logger log = LoggerFactory.getLogger(LocalFileConfig.class);
    @Value(value="${s2.dict.directory.latest:/data/dictionary/custom}")
    private String dictDirectoryLatest;
    @Value(value="${s2.dict.directory.backup:./data/dictionary/backup}")
    private String dictDirectoryBackup;

    public String getDictDirectoryLatest() {
        return this.getDictDirectoryPrefixDir() + this.dictDirectoryLatest;
    }

    public String getDictDirectoryBackup() {
        return this.getDictDirectoryPrefixDir() + this.dictDirectoryBackup;
    }

    private String getDictDirectoryPrefixDir() {
        try {
            return HanlpHelper.getHanlpPropertiesPath();
        }
        catch (FileNotFoundException e) {
            log.error("getDictDirectoryPrefixDir error: ", (Throwable)e);
            return "";
        }
    }

    public void setDictDirectoryLatest(String dictDirectoryLatest) {
        this.dictDirectoryLatest = dictDirectoryLatest;
    }

    public void setDictDirectoryBackup(String dictDirectoryBackup) {
        this.dictDirectoryBackup = dictDirectoryBackup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFileConfig)) {
            return false;
        }
        LocalFileConfig other = (LocalFileConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dictDirectoryLatest = this.getDictDirectoryLatest();
        String other$dictDirectoryLatest = other.getDictDirectoryLatest();
        if (this$dictDirectoryLatest == null ? other$dictDirectoryLatest != null : !this$dictDirectoryLatest.equals(other$dictDirectoryLatest)) {
            return false;
        }
        String this$dictDirectoryBackup = this.getDictDirectoryBackup();
        String other$dictDirectoryBackup = other.getDictDirectoryBackup();
        return !(this$dictDirectoryBackup == null ? other$dictDirectoryBackup != null : !this$dictDirectoryBackup.equals(other$dictDirectoryBackup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalFileConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dictDirectoryLatest = this.getDictDirectoryLatest();
        result = result * 59 + ($dictDirectoryLatest == null ? 43 : $dictDirectoryLatest.hashCode());
        String $dictDirectoryBackup = this.getDictDirectoryBackup();
        result = result * 59 + ($dictDirectoryBackup == null ? 43 : $dictDirectoryBackup.hashCode());
        return result;
    }

    public String toString() {
        return "LocalFileConfig(dictDirectoryLatest=" + this.getDictDirectoryLatest() + ", dictDirectoryBackup=" + this.getDictDirectoryBackup() + ")";
    }
}

