/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.helper;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);
    public static final String FILE_SPILT = File.separator;

    public static void deleteCacheFile(String[] path) throws IOException {
        File[] customSubFiles;
        String customPath = FileHelper.getCustomPath(path);
        File customFolder = new File(customPath);
        for (File file : customSubFiles = FileHelper.getFileList(customFolder, ".bin")) {
            try {
                file.delete();
                log.info("customPath:{},delete file:{}", (Object)customPath, (Object)file);
            }
            catch (Exception e) {
                log.error("delete " + file, (Throwable)e);
            }
        }
    }

    private static File[] getFileList(File customFolder, String suffix) {
        File[] customSubFiles = customFolder.listFiles(file -> {
            if (file.isDirectory()) {
                return false;
            }
            return file.getName().toLowerCase().endsWith(suffix);
        });
        return customSubFiles;
    }

    private static String getCustomPath(String[] path) {
        return path[0].substring(0, path[0].lastIndexOf(FILE_SPILT)) + FILE_SPILT;
    }

    public static void resetCustomPath(DynamicCustomDictionary customDictionary) {
        String[] path = HanLP.Config.CustomDictionaryPath;
        String customPath = FileHelper.getCustomPath(path);
        File customFolder = new File(customPath);
        File[] customSubFiles = FileHelper.getFileList(customFolder, ".txt");
        ArrayList<String> fileList = new ArrayList<String>();
        for (File file : customSubFiles) {
            if (!file.isFile()) continue;
            fileList.add(file.getAbsolutePath());
        }
        log.debug("CustomDictionaryPath:{}", fileList);
        HanLP.Config.CustomDictionaryPath = fileList.toArray(new String[0]);
        String[] stringArray = customDictionary.path = HanLP.Config.CustomDictionaryPath == null || HanLP.Config.CustomDictionaryPath.length == 0 ? path : HanLP.Config.CustomDictionaryPath;
        if (HanLP.Config.CustomDictionaryPath == null || HanLP.Config.CustomDictionaryPath.length == 0) {
            HanLP.Config.CustomDictionaryPath = path;
        }
    }
}

