/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.knowledge.helper;

import com.google.common.collect.Lists;
import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.knowledge.DatabaseMapResult;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.EmbeddingResult;
import com.tencent.supersonic.headless.chat.knowledge.HadoopFileIOAdapter;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.MapResult;
import com.tencent.supersonic.headless.chat.knowledge.MultiCustomDictionary;
import com.tencent.supersonic.headless.chat.knowledge.SearchService;
import com.tencent.supersonic.headless.chat.knowledge.helper.FileHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.HdfsFileHelper;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

public class HanlpHelper {
    private static final Logger log = LoggerFactory.getLogger(HanlpHelper.class);
    public static final String FILE_SPILT = File.separator;
    public static final String SPACE_SPILT = "#";
    private static volatile DynamicCustomDictionary CustomDictionary;
    private static volatile Segment segment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Segment getSegment() {
        if (segment != null) return segment;
        Class<HanlpHelper> clazz = HanlpHelper.class;
        synchronized (HanlpHelper.class) {
            if (segment != null) return segment;
            segment = HanLP.newSegment().enableIndexMode(true).enableIndexMode(4).enableCustomDictionary(true).enableCustomDictionaryForcing(true).enableOffset(true).enableJapaneseNameRecognize(false).enableNameRecognize(false).enableAllNamedEntityRecognize(false).enableJapaneseNameRecognize(false).enableNumberQuantifierRecognize(false).enablePlaceRecognize(false).enableOrganizationRecognize(false).enableCustomDictionary(HanlpHelper.getDynamicCustomDictionary());
            // ** MonitorExit[var0] (shouldn't be in output)
            return segment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicCustomDictionary getDynamicCustomDictionary() {
        if (CustomDictionary != null) return CustomDictionary;
        Class<HanlpHelper> clazz = HanlpHelper.class;
        synchronized (HanlpHelper.class) {
            if (CustomDictionary != null) return CustomDictionary;
            CustomDictionary = new MultiCustomDictionary(HanLP.Config.CustomDictionaryPath);
            // ** MonitorExit[var0] (shouldn't be in output)
            return CustomDictionary;
        }
    }

    public static boolean reloadCustomDictionary() throws IOException {
        long startTime = System.currentTimeMillis();
        if (HanLP.Config.CustomDictionaryPath == null || HanLP.Config.CustomDictionaryPath.length == 0) {
            return false;
        }
        if (HanLP.Config.IOAdapter instanceof HadoopFileIOAdapter) {
            HdfsFileHelper.deleteCacheFile(HanLP.Config.CustomDictionaryPath);
            HdfsFileHelper.resetCustomPath(HanlpHelper.getDynamicCustomDictionary());
        } else {
            FileHelper.deleteCacheFile(HanLP.Config.CustomDictionaryPath);
            FileHelper.resetCustomPath(HanlpHelper.getDynamicCustomDictionary());
        }
        SearchService.clear();
        boolean reload = HanlpHelper.getDynamicCustomDictionary().reload();
        if (reload) {
            log.info("Custom dictionary has been reloaded in {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
        }
        return reload;
    }

    private static void resetHanlpConfig() throws FileNotFoundException {
        if (HanLP.Config.IOAdapter instanceof HadoopFileIOAdapter) {
            return;
        }
        String hanlpPropertiesPath = HanlpHelper.getHanlpPropertiesPath();
        HanLP.Config.CustomDictionaryPath = (String[])Arrays.stream(HanLP.Config.CustomDictionaryPath).map(path -> hanlpPropertiesPath + FILE_SPILT + path).toArray(String[]::new);
        log.info("hanlpPropertiesPath:{},CustomDictionaryPath:{}", (Object)hanlpPropertiesPath, (Object)HanLP.Config.CustomDictionaryPath);
        HanLP.Config.CoreDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.BiGramDictionaryPath;
        HanLP.Config.CoreDictionaryTransformMatrixDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CoreDictionaryTransformMatrixDictionaryPath;
        HanLP.Config.BiGramDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.BiGramDictionaryPath;
        HanLP.Config.CoreStopWordDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CoreStopWordDictionaryPath;
        HanLP.Config.CoreSynonymDictionaryDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CoreSynonymDictionaryDictionaryPath;
        HanLP.Config.PersonDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PersonDictionaryPath;
        HanLP.Config.PersonDictionaryTrPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PersonDictionaryTrPath;
        HanLP.Config.PinyinDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PinyinDictionaryPath;
        HanLP.Config.TranslatedPersonDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.TranslatedPersonDictionaryPath;
        HanLP.Config.JapanesePersonDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.JapanesePersonDictionaryPath;
        HanLP.Config.PlaceDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PlaceDictionaryPath;
        HanLP.Config.PlaceDictionaryTrPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PlaceDictionaryTrPath;
        HanLP.Config.OrganizationDictionaryPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.OrganizationDictionaryPath;
        HanLP.Config.OrganizationDictionaryTrPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.OrganizationDictionaryTrPath;
        HanLP.Config.CharTypePath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CharTypePath;
        HanLP.Config.CharTablePath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CharTablePath;
        HanLP.Config.PartOfSpeechTagDictionary = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PartOfSpeechTagDictionary;
        HanLP.Config.WordNatureModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.WordNatureModelPath;
        HanLP.Config.MaxEntModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.MaxEntModelPath;
        HanLP.Config.NNParserModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.NNParserModelPath;
        HanLP.Config.PerceptronParserModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PerceptronParserModelPath;
        HanLP.Config.CRFSegmentModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CRFSegmentModelPath;
        HanLP.Config.HMMSegmentModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.HMMSegmentModelPath;
        HanLP.Config.CRFCWSModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CRFCWSModelPath;
        HanLP.Config.CRFPOSModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CRFPOSModelPath;
        HanLP.Config.CRFNERModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.CRFNERModelPath;
        HanLP.Config.PerceptronCWSModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PerceptronCWSModelPath;
        HanLP.Config.PerceptronPOSModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PerceptronPOSModelPath;
        HanLP.Config.PerceptronNERModelPath = hanlpPropertiesPath + FILE_SPILT + HanLP.Config.PerceptronNERModelPath;
    }

    public static String getHanlpPropertiesPath() throws FileNotFoundException {
        return ResourceUtils.getFile((String)"classpath:hanlp.properties").getParent();
    }

    public static boolean addToCustomDictionary(DictWord dictWord) {
        log.debug("dictWord:{}", (Object)dictWord);
        return HanlpHelper.getDynamicCustomDictionary().insert(dictWord.getWord(), dictWord.getNatureWithFrequency());
    }

    public static void removeFromCustomDictionary(DictWord dictWord) {
        log.debug("dictWord:{}", (Object)dictWord);
        CoreDictionary.Attribute attribute = HanlpHelper.getDynamicCustomDictionary().get(dictWord.getWord());
        if (attribute == null) {
            return;
        }
        log.info("get attribute:{}", (Object)attribute);
        HanlpHelper.getDynamicCustomDictionary().remove(dictWord.getWord());
        StringBuilder sb = new StringBuilder();
        ArrayList<Nature> natureList = new ArrayList<Nature>();
        for (int i = 0; i < attribute.nature.length; ++i) {
            if (attribute.nature[i].toString().equals(dictWord.getNature())) continue;
            sb.append(attribute.nature[i].toString() + " ");
            sb.append(attribute.frequency[i] + " ");
            natureList.add(attribute.nature[i]);
        }
        String natureWithFrequency = sb.toString();
        int len = natureWithFrequency.length();
        log.info("filtered natureWithFrequency:{}", (Object)natureWithFrequency);
        if (StringUtils.isNotBlank((CharSequence)natureWithFrequency)) {
            HanlpHelper.getDynamicCustomDictionary().add(dictWord.getWord(), natureWithFrequency.substring(0, len - 1));
        }
        SearchService.remove(dictWord, natureList.toArray(new Nature[0]));
    }

    public static <T extends MapResult> void transLetterOriginal(List<T> mapResults) {
        if (CollectionUtils.isEmpty(mapResults)) {
            return;
        }
        ArrayList<MapResult> newResults = new ArrayList<MapResult>();
        for (MapResult mapResult : mapResults) {
            CoreDictionary.Attribute attribute;
            boolean isAdd = false;
            if (MultiCustomDictionary.isLowerLetter(mapResult.getName()) && CustomDictionary.contains(mapResult.getName()) && (attribute = CustomDictionary.get(mapResult.getName())) != null) {
                isAdd = HanlpHelper.addLetterOriginal(newResults, mapResult, attribute);
            }
            if (isAdd) continue;
            newResults.add(mapResult);
        }
        mapResults.clear();
        mapResults.addAll(newResults);
    }

    public static <T extends MapResult> boolean addLetterOriginal(List<T> mapResults, T mapResult, CoreDictionary.Attribute attribute) {
        boolean isAdd;
        block4: {
            List originals;
            block6: {
                block5: {
                    isAdd = false;
                    if (attribute == null) break block4;
                    if (!(mapResult instanceof HanlpMapResult)) break block5;
                    HanlpMapResult hanlpMapResult = (HanlpMapResult)mapResult;
                    for (String nature : hanlpMapResult.getNatures()) {
                        String orig = attribute.getOriginal(Nature.fromString((String)nature));
                        if (orig == null) continue;
                        HanlpMapResult addMapResult = new HanlpMapResult(orig, Arrays.asList(nature), hanlpMapResult.getDetectWord());
                        mapResults.add(addMapResult);
                        isAdd = true;
                    }
                    break block4;
                }
                if (!(mapResult instanceof DatabaseMapResult)) break block6;
                List originals2 = attribute.getOriginals();
                if (CollectionUtils.isEmpty((Collection)originals2)) break block4;
                for (String orig : originals2) {
                    DatabaseMapResult addMapResult = new DatabaseMapResult();
                    addMapResult.setName(orig);
                    addMapResult.setSchemaElement(((DatabaseMapResult)mapResult).getSchemaElement());
                    addMapResult.setDetectWord(mapResult.getDetectWord());
                    mapResults.add(addMapResult);
                    isAdd = true;
                }
                break block4;
            }
            if (mapResult instanceof EmbeddingResult && !CollectionUtils.isEmpty((Collection)(originals = attribute.getOriginals()))) {
                for (String orig : originals) {
                    EmbeddingResult addMapResult = new EmbeddingResult();
                    addMapResult.setName(orig);
                    addMapResult.setDetectWord(mapResult.getDetectWord());
                    addMapResult.setId(((EmbeddingResult)mapResult).getId());
                    addMapResult.setMetadata(((EmbeddingResult)mapResult).getMetadata());
                    addMapResult.setDistance(((EmbeddingResult)mapResult).getDistance());
                    mapResults.add(addMapResult);
                    isAdd = true;
                }
            }
        }
        return isAdd;
    }

    public static List<S2Term> getTerms(String text, Map<Long, List<Long>> modelIdToDataSetIds) {
        return HanlpHelper.getSegment().seg(text.toLowerCase()).stream().filter(term -> term.getNature().startsWith("_")).map(term -> HanlpHelper.transform2ApiTerm(term, modelIdToDataSetIds)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<S2Term> transform2ApiTerm(Term term, Map<Long, List<Long>> modelIdToDataSetIds) {
        ArrayList s2Terms = Lists.newArrayList();
        List<String> natures = NatureHelper.changeModel2DataSet(String.valueOf(term.getNature()), modelIdToDataSetIds);
        for (String nature : natures) {
            S2Term s2Term = new S2Term();
            BeanUtils.copyProperties((Object)term, (Object)s2Term);
            s2Term.setNature(Nature.create((String)nature));
            s2Term.setFrequency(term.getFrequency());
            s2Terms.add(s2Term);
        }
        return s2Terms;
    }

    static {
        try {
            HanlpHelper.resetHanlpConfig();
        }
        catch (FileNotFoundException e) {
            log.error("resetHanlpConfig error", (Throwable)e);
        }
    }
}

