/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.headless.api.pojo.enums.MapModeEnum;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.helper.NatureHelper;
import com.tencent.supersonic.headless.chat.mapper.MapperConfig;
import com.tencent.supersonic.headless.chat.mapper.MapperHelper;
import com.tencent.supersonic.headless.chat.mapper.MatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.MatchText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseMatchStrategy<T>
implements MatchStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseMatchStrategy.class);
    @Autowired
    protected MapperHelper mapperHelper;
    @Autowired
    protected MapperConfig mapperConfig;

    @Override
    public Map<MatchText, List<T>> match(ChatQueryContext chatQueryContext, List<S2Term> terms, Set<Long> detectDataSetIds) {
        String text = chatQueryContext.getQueryText();
        if (Objects.isNull(terms) || StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        log.debug("terms:{},,detectDataSetIds:{}", terms, detectDataSetIds);
        List<T> detects = this.detect(chatQueryContext, terms, detectDataSetIds);
        HashMap<MatchText, List<T>> result = new HashMap<MatchText, List<T>>();
        result.put(MatchText.builder().regText(text).detectSegment(text).build(), detects);
        return result;
    }

    public List<T> detect(ChatQueryContext chatQueryContext, List<S2Term> terms, Set<Long> detectDataSetIds) {
        Map<Integer, Integer> regOffsetToLength = this.getRegOffsetToLength(terms);
        String text = chatQueryContext.getQueryText();
        HashSet results = new HashSet();
        HashSet<String> detectSegments = new HashSet<String>();
        Integer startIndex = 0;
        while (startIndex <= text.length() - 1) {
            Integer index = startIndex;
            while (index <= text.length()) {
                int offset = this.mapperHelper.getStepOffset(terms, startIndex);
                if ((index = this.mapperHelper.getStepIndex(regOffsetToLength, index)) > text.length()) continue;
                String detectSegment = text.substring(startIndex, index).trim();
                detectSegments.add(detectSegment);
                this.detectByStep(chatQueryContext, results, detectDataSetIds, detectSegment, offset);
            }
            startIndex = this.mapperHelper.getStepIndex(regOffsetToLength, startIndex);
        }
        this.detectByBatch(chatQueryContext, results, detectDataSetIds, detectSegments);
        return new ArrayList(results);
    }

    protected void detectByBatch(ChatQueryContext chatQueryContext, Set<T> results, Set<Long> detectDataSetIds, Set<String> detectSegments) {
    }

    public Map<Integer, Integer> getRegOffsetToLength(List<S2Term> terms) {
        return terms.stream().sorted(Comparator.comparing(S2Term::length)).collect(Collectors.toMap(S2Term::getOffset, term -> term.word.length(), (value1, value2) -> value2));
    }

    public void selectResultInOneRound(Set<T> existResults, List<T> oneRoundResults) {
        if (CollectionUtils.isEmpty(oneRoundResults)) {
            return;
        }
        for (T oneRoundResult : oneRoundResults) {
            if (existResults.contains(oneRoundResult)) {
                boolean isDeleted = existResults.removeIf(existResult -> {
                    boolean delete = this.needDelete(oneRoundResult, existResult);
                    if (delete) {
                        log.info("deleted existResult:{}", existResult);
                    }
                    return delete;
                });
                if (!isDeleted) continue;
                log.info("deleted, add oneRoundResult:{}", oneRoundResult);
                existResults.add(oneRoundResult);
                continue;
            }
            existResults.add(oneRoundResult);
        }
    }

    public List<T> getMatches(ChatQueryContext chatQueryContext, List<S2Term> terms) {
        Set<Long> dataSetIds = chatQueryContext.getDataSetIds();
        terms = this.filterByDataSetId(terms, dataSetIds);
        Map<MatchText, List<T>> matchResult = this.match(chatQueryContext, terms, dataSetIds);
        List matches = new ArrayList();
        if (Objects.isNull(matchResult)) {
            return matches;
        }
        Optional<List> first = matchResult.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).map(entry -> (List)entry.getValue()).findFirst();
        if (first.isPresent()) {
            matches = first.get();
        }
        return matches;
    }

    public List<S2Term> filterByDataSetId(List<S2Term> terms, Set<Long> dataSetIds) {
        this.logTerms(terms);
        if (CollectionUtils.isNotEmpty(dataSetIds)) {
            terms = terms.stream().filter(term -> {
                Long dataSetId = NatureHelper.getDataSetId(term.getNature().toString());
                if (Objects.nonNull(dataSetId)) {
                    return dataSetIds.contains(dataSetId);
                }
                return false;
            }).collect(Collectors.toList());
            log.debug("terms filter by dataSetId:{}", dataSetIds);
            this.logTerms(terms);
        }
        return terms;
    }

    public void logTerms(List<S2Term> terms) {
        if (CollectionUtils.isEmpty(terms)) {
            return;
        }
        for (S2Term term : terms) {
            log.debug("word:{},nature:{},frequency:{}", new Object[]{term.word, term.nature.toString(), term.getFrequency()});
        }
    }

    public abstract boolean needDelete(T var1, T var2);

    public abstract String getMapKey(T var1);

    public abstract void detectByStep(ChatQueryContext var1, Set<T> var2, Set<Long> var3, String var4, int var5);

    public double getThreshold(Double threshold, Double minThreshold, MapModeEnum mapModeEnum) {
        double decreaseAmount = (threshold - minThreshold) / 4.0;
        double divideThreshold = threshold - (double)mapModeEnum.threshold * decreaseAmount;
        return divideThreshold >= minThreshold ? divideThreshold : minThreshold;
    }
}

