/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.DatabaseMapResult;
import com.tencent.supersonic.headless.chat.mapper.BaseMatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.MapperConfig;
import com.tencent.supersonic.headless.chat.mapper.MatchText;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DatabaseMatchStrategy
extends BaseMatchStrategy<DatabaseMapResult> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMatchStrategy.class);
    private List<SchemaElement> allElements;

    @Override
    public Map<MatchText, List<DatabaseMapResult>> match(ChatQueryContext chatQueryContext, List<S2Term> terms, Set<Long> detectDataSetIds) {
        this.allElements = this.getSchemaElements(chatQueryContext);
        return super.match(chatQueryContext, terms, detectDataSetIds);
    }

    @Override
    public boolean needDelete(DatabaseMapResult oneRoundResult, DatabaseMapResult existResult) {
        return this.getMapKey(oneRoundResult).equals(this.getMapKey(existResult)) && existResult.getDetectWord().length() < oneRoundResult.getDetectWord().length();
    }

    @Override
    public String getMapKey(DatabaseMapResult a) {
        return a.getName() + "_" + a.getSchemaElement().getId() + "_" + a.getSchemaElement().getName();
    }

    @Override
    public void detectByStep(ChatQueryContext chatQueryContext, Set<DatabaseMapResult> existResults, Set<Long> detectDataSetIds, String detectSegment, int offset) {
        if (StringUtils.isBlank((CharSequence)detectSegment)) {
            return;
        }
        Double metricDimensionThresholdConfig = this.getThreshold(chatQueryContext);
        Map<String, Set<SchemaElement>> nameToItems = this.getNameToItems(this.allElements);
        for (Map.Entry<String, Set<SchemaElement>> entry : nameToItems.entrySet()) {
            String name = entry.getKey();
            if (!name.contains(detectSegment) || this.mapperHelper.getSimilarity(detectSegment, name) < metricDimensionThresholdConfig) continue;
            Set<Object> schemaElements = entry.getValue();
            if (!CollectionUtils.isEmpty(detectDataSetIds)) {
                schemaElements = schemaElements.stream().filter(schemaElement -> detectDataSetIds.contains(schemaElement.getDataSet())).collect(Collectors.toSet());
            }
            for (SchemaElement schemaElement2 : schemaElements) {
                DatabaseMapResult databaseMapResult = new DatabaseMapResult();
                databaseMapResult.setDetectWord(detectSegment);
                databaseMapResult.setName(schemaElement2.getName());
                databaseMapResult.setSchemaElement(schemaElement2);
                existResults.add(databaseMapResult);
            }
        }
    }

    private List<SchemaElement> getSchemaElements(ChatQueryContext chatQueryContext) {
        ArrayList<SchemaElement> allElements = new ArrayList<SchemaElement>();
        allElements.addAll(chatQueryContext.getSemanticSchema().getDimensions());
        allElements.addAll(chatQueryContext.getSemanticSchema().getMetrics());
        return allElements;
    }

    private Double getThreshold(ChatQueryContext chatQueryContext) {
        Double threshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_NAME_THRESHOLD));
        Double minThreshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_NAME_THRESHOLD_MIN));
        Map modelElementMatches = chatQueryContext.getMapInfo().getDataSetElementMatches();
        boolean existElement = modelElementMatches.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).size() >= 1);
        if (!existElement) {
            threshold = threshold / 2.0;
            log.debug("ModelElementMatches:{},not exist Element threshold reduce by half:{}", (Object)modelElementMatches, (Object)threshold);
        }
        return this.getThreshold(threshold, minThreshold, chatQueryContext.getMapModeEnum());
    }

    private Map<String, Set<SchemaElement>> getNameToItems(List<SchemaElement> models) {
        return models.stream().collect(Collectors.toMap(SchemaElement::getName, a -> {
            HashSet<SchemaElement> result = new HashSet<SchemaElement>();
            result.add((SchemaElement)a);
            return result;
        }, (k1, k2) -> {
            k1.addAll(k2);
            return k1;
        }));
    }
}

