/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.EmbeddingResult;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordBuilder;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.chat.mapper.BaseMapper;
import com.tencent.supersonic.headless.chat.mapper.EmbeddingMatchStrategy;
import dev.langchain4j.store.embedding.Retrieval;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingMapper
extends BaseMapper {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingMapper.class);

    @Override
    public void doMap(ChatQueryContext chatQueryContext) {
        String queryText = chatQueryContext.getQueryText();
        List<S2Term> terms = HanlpHelper.getTerms(queryText, chatQueryContext.getModelIdToDataSetIds());
        EmbeddingMatchStrategy matchStrategy = (EmbeddingMatchStrategy)ContextUtils.getBean(EmbeddingMatchStrategy.class);
        List matchResults = matchStrategy.getMatches(chatQueryContext, terms);
        HanlpHelper.transLetterOriginal(matchResults);
        for (EmbeddingResult matchResult : matchResults) {
            SchemaElementType elementType;
            SchemaElement schemaElement;
            Long elementId = Retrieval.getLongId((Object)matchResult.getId());
            Long dataSetId = Retrieval.getLongId((Object)matchResult.getMetadata().get("dataSetId"));
            if (Objects.isNull(dataSetId) || (schemaElement = this.getSchemaElement(dataSetId, elementType = SchemaElementType.valueOf((String)matchResult.getMetadata().get("type")), elementId, chatQueryContext.getSemanticSchema())) == null) continue;
            SchemaElementMatch schemaElementMatch = SchemaElementMatch.builder().element(schemaElement).frequency(BaseWordBuilder.DEFAULT_FREQUENCY).word(matchResult.getName()).similarity(1.0 - matchResult.getDistance()).detectWord(matchResult.getDetectWord()).build();
            this.addToSchemaMap(chatQueryContext.getMapInfo(), dataSetId, schemaElementMatch);
        }
    }
}

