/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.mapper.BaseMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class EntityMapper
extends BaseMapper {
    private static final Logger log = LoggerFactory.getLogger(EntityMapper.class);

    @Override
    public void doMap(ChatQueryContext chatQueryContext) {
        SchemaMapInfo schemaMapInfo = chatQueryContext.getMapInfo();
        for (Long dataSetId : schemaMapInfo.getMatchedDataSetInfos()) {
            SchemaElement entity;
            List schemaElementMatchList = schemaMapInfo.getMatchedElements(dataSetId);
            if (CollectionUtils.isEmpty((Collection)schemaElementMatchList) || (entity = this.getEntity(dataSetId, chatQueryContext)) == null || entity.getId() == null) continue;
            List valueSchemaElements = schemaElementMatchList.stream().filter(schemaElementMatch -> SchemaElementType.VALUE.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toList());
            for (SchemaElementMatch schemaElementMatch2 : valueSchemaElements) {
                if (!entity.getId().equals(schemaElementMatch2.getElement().getId())) continue;
                if (!this.checkExistSameEntitySchemaElements(schemaElementMatch2, schemaElementMatchList)) {
                    SchemaElementMatch entitySchemaElementMath = new SchemaElementMatch();
                    BeanUtils.copyProperties((Object)schemaElementMatch2, (Object)entitySchemaElementMath);
                    entitySchemaElementMath.setElement(entity);
                    schemaElementMatchList.add(entitySchemaElementMath);
                }
                schemaElementMatch2.getElement().setType(SchemaElementType.ID);
            }
        }
    }

    private boolean checkExistSameEntitySchemaElements(SchemaElementMatch valueSchemaElementMatch, List<SchemaElementMatch> schemaElementMatchList) {
        List entitySchemaElements = schemaElementMatchList.stream().filter(schemaElementMatch -> SchemaElementType.ENTITY.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toList());
        for (SchemaElementMatch schemaElementMatch2 : entitySchemaElements) {
            if (!schemaElementMatch2.getElement().getId().equals(valueSchemaElementMatch.getElement().getId())) continue;
            return true;
        }
        return false;
    }

    private SchemaElement getEntity(Long dataSetId, ChatQueryContext chatQueryContext) {
        SemanticSchema semanticSchema = chatQueryContext.getSemanticSchema();
        DataSetSchema modelSchema = (DataSetSchema)semanticSchema.getDataSetSchemaMap().get(dataSetId);
        if (modelSchema != null && modelSchema.getEntity() != null) {
            return modelSchema.getEntity();
        }
        return null;
    }
}

