/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.tencent.supersonic.headless.api.pojo.response.S2Term;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.HanlpMapResult;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.mapper.BaseMatchStrategy;
import com.tencent.supersonic.headless.chat.mapper.MapperConfig;
import com.tencent.supersonic.headless.chat.mapper.MatchText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HanlpDictMatchStrategy
extends BaseMatchStrategy<HanlpMapResult> {
    private static final Logger log = LoggerFactory.getLogger(HanlpDictMatchStrategy.class);
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;

    @Override
    public Map<MatchText, List<HanlpMapResult>> match(ChatQueryContext chatQueryContext, List<S2Term> terms, Set<Long> detectDataSetIds) {
        String text = chatQueryContext.getQueryText();
        if (Objects.isNull(terms) || StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        log.debug("terms:{},detectModelIds:{}", terms, detectDataSetIds);
        List detects = this.detect(chatQueryContext, terms, detectDataSetIds);
        HashMap<MatchText, List<HanlpMapResult>> result = new HashMap<MatchText, List<HanlpMapResult>>();
        result.put(MatchText.builder().regText(text).detectSegment(text).build(), detects);
        return result;
    }

    @Override
    public boolean needDelete(HanlpMapResult oneRoundResult, HanlpMapResult existResult) {
        return this.getMapKey(oneRoundResult).equals(this.getMapKey(existResult)) && existResult.getDetectWord().length() < oneRoundResult.getDetectWord().length();
    }

    @Override
    public void detectByStep(ChatQueryContext chatQueryContext, Set<HanlpMapResult> existResults, Set<Long> detectDataSetIds, String detectSegment, int offset) {
        Integer oneDetectionMaxSize = Integer.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_DETECTION_MAX_SIZE));
        LinkedHashSet hanlpMapResults = this.knowledgeBaseService.prefixSearch(detectSegment, oneDetectionMaxSize, chatQueryContext.getModelIdToDataSetIds(), detectDataSetIds).stream().collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet suffixHanlpMapResults = this.knowledgeBaseService.suffixSearch(detectSegment, oneDetectionMaxSize, chatQueryContext.getModelIdToDataSetIds(), detectDataSetIds).stream().collect(Collectors.toCollection(LinkedHashSet::new));
        hanlpMapResults.addAll(suffixHanlpMapResults);
        if (CollectionUtils.isEmpty((Collection)hanlpMapResults)) {
            return;
        }
        hanlpMapResults = hanlpMapResults.stream().sorted((a, b) -> -(b.getName().length() - a.getName().length())).collect(Collectors.toCollection(LinkedHashSet::new));
        hanlpMapResults = hanlpMapResults.stream().filter(term -> this.mapperHelper.getSimilarity(detectSegment, term.getName()) >= this.getThresholdMatch(term.getNatures(), chatQueryContext)).filter(term -> CollectionUtils.isNotEmpty(term.getNatures())).collect(Collectors.toCollection(LinkedHashSet::new));
        log.debug("detectSegment:{},after isSimilarity parseResults:{}", (Object)detectSegment, (Object)hanlpMapResults);
        hanlpMapResults = hanlpMapResults.stream().map(parseResult -> {
            parseResult.setOffset(offset);
            parseResult.setSimilarity(this.mapperHelper.getSimilarity(detectSegment, parseResult.getName()));
            return parseResult;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        int oneDetectionValueSize = Integer.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_DIMENSION_VALUE_SIZE));
        List dimensionValues = hanlpMapResults.stream().filter(entry -> this.mapperHelper.existDimensionValues(entry.getNatures())).limit(oneDetectionValueSize).collect(Collectors.toList());
        Integer oneDetectionSize = Integer.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_DETECTION_SIZE));
        ArrayList oneRoundResults = new ArrayList();
        if (CollectionUtils.isNotEmpty(dimensionValues)) {
            oneRoundResults.addAll(dimensionValues);
        }
        if (oneRoundResults.size() < oneDetectionSize) {
            List additionalResults = hanlpMapResults.stream().filter(entry -> !this.mapperHelper.existDimensionValues(entry.getNatures()) && !oneRoundResults.contains(entry)).limit(oneDetectionSize - oneRoundResults.size()).collect(Collectors.toList());
            oneRoundResults.addAll(additionalResults);
        }
        this.selectResultInOneRound(existResults, oneRoundResults);
    }

    @Override
    public String getMapKey(HanlpMapResult a) {
        return a.getName() + "_" + String.join((CharSequence)"_", a.getNatures());
    }

    public double getThresholdMatch(List<String> natures, ChatQueryContext chatQueryContext) {
        Double threshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_NAME_THRESHOLD));
        Double minThreshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_NAME_THRESHOLD_MIN));
        if (this.mapperHelper.existDimensionValues(natures)) {
            threshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_VALUE_THRESHOLD));
            minThreshold = Double.valueOf(this.mapperConfig.getParameterValue(MapperConfig.MAPPER_VALUE_THRESHOLD_MIN));
        }
        return this.getThreshold(threshold, minThreshold, chatQueryContext.getMapModeEnum());
    }
}

