/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.mapper;

import com.google.common.collect.Lists;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaMapInfo;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryFilters;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.knowledge.builder.BaseWordBuilder;
import com.tencent.supersonic.headless.chat.mapper.BaseMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QueryFilterMapper
extends BaseMapper {
    private static final Logger log = LoggerFactory.getLogger(QueryFilterMapper.class);
    private double similarity = 1.0;

    @Override
    public void doMap(ChatQueryContext chatQueryContext) {
        Set<Long> dataSetIds = chatQueryContext.getDataSetIds();
        if (CollectionUtils.isEmpty(dataSetIds)) {
            return;
        }
        SchemaMapInfo schemaMapInfo = chatQueryContext.getMapInfo();
        this.clearOtherSchemaElementMatch(dataSetIds, schemaMapInfo);
        for (Long dataSetId : dataSetIds) {
            List schemaElementMatches = schemaMapInfo.getMatchedElements(dataSetId);
            if (schemaElementMatches == null) {
                schemaElementMatches = Lists.newArrayList();
                schemaMapInfo.setMatchedElements(dataSetId, schemaElementMatches);
            }
            this.addValueSchemaElementMatch(dataSetId, chatQueryContext, schemaElementMatches);
        }
    }

    private void clearOtherSchemaElementMatch(Set<Long> viewIds, SchemaMapInfo schemaMapInfo) {
        for (Map.Entry entry : schemaMapInfo.getDataSetElementMatches().entrySet()) {
            if (viewIds.contains(entry.getKey())) continue;
            ((List)entry.getValue()).clear();
        }
    }

    private void addValueSchemaElementMatch(Long dataSetId, ChatQueryContext chatQueryContext, List<SchemaElementMatch> candidateElementMatches) {
        QueryFilters queryFilters = chatQueryContext.getQueryFilters();
        if (queryFilters == null || CollectionUtils.isEmpty((Collection)queryFilters.getFilters())) {
            return;
        }
        for (QueryFilter filter : queryFilters.getFilters()) {
            if (this.checkExistSameValueSchemaElementMatch(filter, candidateElementMatches)) continue;
            SchemaElement element = SchemaElement.builder().id(filter.getElementID()).name(String.valueOf(filter.getValue())).type(SchemaElementType.VALUE).bizName(filter.getBizName()).dataSet(dataSetId).build();
            SchemaElementMatch schemaElementMatch = SchemaElementMatch.builder().element(element).frequency(BaseWordBuilder.DEFAULT_FREQUENCY).word(String.valueOf(filter.getValue())).similarity(this.similarity).detectWord("").build();
            candidateElementMatches.add(schemaElementMatch);
        }
        chatQueryContext.getMapInfo().setMatchedElements(dataSetId, candidateElementMatches);
    }

    private boolean checkExistSameValueSchemaElementMatch(QueryFilter queryFilter, List<SchemaElementMatch> schemaElementMatches) {
        List valueSchemaElements = schemaElementMatches.stream().filter(schemaElementMatch -> SchemaElementType.VALUE.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toList());
        for (SchemaElementMatch schemaElementMatch2 : valueSchemaElements) {
            if (!schemaElementMatch2.getElement().getId().equals(queryFilter.getElementID()) || !schemaElementMatch2.getWord().equals(String.valueOf(queryFilter.getValue()))) continue;
            return true;
        }
        return false;
    }
}

