/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.llm;

import com.tencent.supersonic.common.pojo.enums.DataFormatTypeEnum;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.headless.api.pojo.DataSetSchema;
import com.tencent.supersonic.headless.api.pojo.SchemaElement;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SemanticSchema;
import com.tencent.supersonic.headless.api.pojo.TimeDefaultConfig;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.ParserConfig;
import com.tencent.supersonic.headless.chat.parser.SatisfactionChecker;
import com.tencent.supersonic.headless.chat.parser.llm.DataSetResolver;
import com.tencent.supersonic.headless.chat.parser.llm.LLMParserConfig;
import com.tencent.supersonic.headless.chat.parser.llm.LLMSqlParser;
import com.tencent.supersonic.headless.chat.parser.llm.SqlGenStrategy;
import com.tencent.supersonic.headless.chat.parser.llm.SqlGenStrategyFactory;
import com.tencent.supersonic.headless.chat.parser.srmExtend.ModelSqlDataPermissionUtil;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMReq;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMResp;
import com.tencent.supersonic.headless.chat.utils.ComponentFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LLMRequestService {
    private static final Logger log = LoggerFactory.getLogger(LLMRequestService.class);
    @Autowired
    private LLMParserConfig llmParserConfig;
    @Autowired
    private ParserConfig parserConfig;

    public boolean isSkip(ChatQueryContext queryCtx) {
        if (!queryCtx.getText2SQLType().enableLLM()) {
            log.info("not enable llm, skip");
            return true;
        }
        if (SatisfactionChecker.isSkip(queryCtx)) {
            log.info("skip {}, queryText:{}", LLMSqlParser.class, (Object)queryCtx.getQueryText());
            return true;
        }
        return false;
    }

    public Long getDataSetId(ChatQueryContext queryCtx) {
        DataSetResolver dataSetResolver = ComponentFactory.getModelResolver();
        return dataSetResolver.resolve(queryCtx, queryCtx.getDataSetIds());
    }

    public LLMReq getLlmReq(ChatQueryContext queryCtx, Long dataSetId) {
        TimeDefaultConfig timeDefaultConfig;
        LLMRequestService requestService = (LLMRequestService)ContextUtils.getBean(LLMRequestService.class);
        List<LLMReq.ElementValue> linkingValues = requestService.getValues(queryCtx, dataSetId);
        SemanticSchema semanticSchema = queryCtx.getSemanticSchema();
        Map dataSetIdToName = semanticSchema.getDataSetIdToName();
        String queryText = queryCtx.getQueryText();
        LLMReq llmReq = new LLMReq();
        llmReq.setQueryText(queryText);
        LLMReq.FilterCondition filterCondition = new LLMReq.FilterCondition();
        llmReq.setFilterCondition(filterCondition);
        LLMReq.LLMSchema llmSchema = new LLMReq.LLMSchema();
        llmSchema.setDataSetId(dataSetId);
        llmSchema.setDataSetName((String)dataSetIdToName.get(dataSetId));
        llmSchema.setDomainName((String)dataSetIdToName.get(dataSetId));
        List<String> fieldNameList = this.getFieldNameList(queryCtx, dataSetId, this.llmParserConfig);
        if (Objects.nonNull(semanticSchema.getDataSetSchemaMap()) && Objects.nonNull(semanticSchema.getDataSetSchemaMap().get(dataSetId)) && !Objects.equals((timeDefaultConfig = ((DataSetSchema)semanticSchema.getDataSetSchemaMap().get(dataSetId)).getTagTypeTimeDefaultConfig()).getUnit(), -1)) {
            fieldNameList.add(TimeDimensionEnum.DAY.getChName());
        }
        llmSchema.setFieldNameList(fieldNameList);
        llmSchema.setMetrics(this.getMatchedMetrics(queryCtx, dataSetId));
        llmSchema.setDimensions(this.getMatchedDimensions(queryCtx, dataSetId));
        llmSchema.setTerms(this.getTerms(queryCtx, dataSetId));
        llmReq.setSchema(llmSchema);
        String priorExts = this.getPriorExts(queryCtx, fieldNameList);
        llmReq.setPriorExts(priorExts);
        ArrayList<LLMReq.ElementValue> linking = new ArrayList<LLMReq.ElementValue>();
        boolean linkingValueEnabled = Boolean.valueOf(this.parserConfig.getParameterValue(ParserConfig.PARSER_LINKING_VALUE_ENABLE));
        if (linkingValueEnabled) {
            linking.addAll(linkingValues);
        }
        llmReq.setLinking(linking);
        ModelSqlDataPermissionUtil.appendPermissionFilter(llmReq, fieldNameList, linking);
        llmReq.setCurrentDate(DateUtils.getBeforeDate((int)0));
        llmReq.setSqlGenType(LLMReq.SqlGenType.valueOf(this.parserConfig.getParameterValue(ParserConfig.PARSER_STRATEGY_TYPE)));
        llmReq.setModelConfig(queryCtx.getModelConfig());
        llmReq.setPromptConfig(queryCtx.getPromptConfig());
        llmReq.setDynamicExemplars(queryCtx.getDynamicExemplars());
        return llmReq;
    }

    public LLMResp runText2SQL(LLMReq llmReq) {
        SqlGenStrategy sqlGenStrategy = SqlGenStrategyFactory.get(llmReq.getSqlGenType());
        String modelName = llmReq.getSchema().getDataSetName();
        LLMResp result = sqlGenStrategy.generate(llmReq);
        result.setQuery(llmReq.getQueryText());
        result.setModelName(modelName);
        return result;
    }

    protected List<String> getFieldNameList(ChatQueryContext queryCtx, Long dataSetId, LLMParserConfig llmParserConfig) {
        Set<String> results = this.getTopNFieldNames(queryCtx, dataSetId, llmParserConfig);
        Set<String> fieldNameList = this.getMatchedFieldNames(queryCtx, dataSetId);
        results.addAll(fieldNameList);
        return new ArrayList<String>(results);
    }

    protected List<LLMReq.Term> getTerms(ChatQueryContext queryCtx, Long dataSetId) {
        List matchedElements = queryCtx.getMapInfo().getMatchedElements(dataSetId);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return new ArrayList<LLMReq.Term>();
        }
        return matchedElements.stream().filter(schemaElementMatch -> {
            SchemaElementType elementType = schemaElementMatch.getElement().getType();
            return SchemaElementType.TERM.equals((Object)elementType);
        }).map(schemaElementMatch -> {
            LLMReq.Term term = new LLMReq.Term();
            term.setName(schemaElementMatch.getElement().getName());
            term.setDescription(schemaElementMatch.getElement().getDescription());
            term.setAlias(schemaElementMatch.getElement().getAlias());
            return term;
        }).collect(Collectors.toList());
    }

    private String getPriorExts(ChatQueryContext queryContext, List<String> fieldNameList) {
        StringBuilder extraInfoSb = new StringBuilder();
        SemanticSchema semanticSchema = queryContext.getSemanticSchema();
        Map<String, String> fieldNameToDataFormatType = semanticSchema.getMetrics().stream().filter(metricSchemaResp -> Objects.nonNull(metricSchemaResp.getDataFormatType())).flatMap(metricSchemaResp -> {
            HashSet<Pair> result = new HashSet<Pair>();
            String dataFormatType = metricSchemaResp.getDataFormatType();
            result.add(Pair.of((Object)metricSchemaResp.getName(), (Object)dataFormatType));
            List aliasList = metricSchemaResp.getAlias();
            if (!CollectionUtils.isEmpty((Collection)aliasList)) {
                for (String alias : aliasList) {
                    result.add(Pair.of((Object)alias, (Object)dataFormatType));
                }
            }
            return result.stream();
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (k1, k2) -> k1));
        for (String fieldName : fieldNameList) {
            String dataFormatType = fieldNameToDataFormatType.get(fieldName);
            if (!DataFormatTypeEnum.DECIMAL.getName().equalsIgnoreCase(dataFormatType) && !DataFormatTypeEnum.PERCENT.getName().equalsIgnoreCase(dataFormatType)) continue;
            String format = String.format("%s\u7684\u8ba1\u91cf\u5355\u4f4d\u662f%s", fieldName, "\u5c0f\u6570; ");
            extraInfoSb.append(format);
        }
        return extraInfoSb.toString();
    }

    public List<LLMReq.ElementValue> getValues(ChatQueryContext queryCtx, Long dataSetId) {
        Map<Long, String> itemIdToName = this.getItemIdToName(queryCtx, dataSetId);
        List matchedElements = queryCtx.getMapInfo().getMatchedElements(dataSetId);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return new ArrayList<LLMReq.ElementValue>();
        }
        Set valueMatches = matchedElements.stream().filter(elementMatch -> !elementMatch.isInherited()).filter(schemaElementMatch -> {
            SchemaElementType type = schemaElementMatch.getElement().getType();
            return SchemaElementType.VALUE.equals((Object)type) || SchemaElementType.ID.equals((Object)type);
        }).map(elementMatch -> {
            LLMReq.ElementValue elementValue = new LLMReq.ElementValue();
            elementValue.setFieldName((String)itemIdToName.get(elementMatch.getElement().getId()));
            elementValue.setFieldValue(elementMatch.getWord());
            return elementValue;
        }).collect(Collectors.toSet());
        return new ArrayList<LLMReq.ElementValue>(valueMatches);
    }

    protected Map<Long, String> getItemIdToName(ChatQueryContext queryCtx, Long dataSetId) {
        SemanticSchema semanticSchema = queryCtx.getSemanticSchema();
        List elements = semanticSchema.getDimensions(dataSetId);
        return elements.stream().collect(Collectors.toMap(SchemaElement::getId, SchemaElement::getName, (value1, value2) -> value2));
    }

    private Set<String> getTopNFieldNames(ChatQueryContext queryCtx, Long dataSetId, LLMParserConfig llmParserConfig) {
        SemanticSchema semanticSchema = queryCtx.getSemanticSchema();
        HashSet<String> results = new HashSet<String>();
        Set dimensions = semanticSchema.getDimensions(dataSetId).stream().sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).limit(llmParserConfig.getDimensionTopN().intValue()).map(entry -> entry.getName()).collect(Collectors.toSet());
        results.addAll(dimensions);
        Set metrics = semanticSchema.getMetrics(dataSetId).stream().sorted(Comparator.comparing(SchemaElement::getUseCnt).reversed()).limit(llmParserConfig.getMetricTopN().intValue()).map(entry -> entry.getName()).collect(Collectors.toSet());
        results.addAll(metrics);
        return results;
    }

    protected List<SchemaElement> getMatchedMetrics(ChatQueryContext queryCtx, Long dataSetId) {
        List matchedElements = queryCtx.getMapInfo().getMatchedElements(dataSetId);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return Collections.emptyList();
        }
        List<SchemaElement> schemaElements = matchedElements.stream().filter(schemaElementMatch -> {
            SchemaElementType elementType = schemaElementMatch.getElement().getType();
            return SchemaElementType.METRIC.equals((Object)elementType);
        }).map(schemaElementMatch -> schemaElementMatch.getElement()).collect(Collectors.toList());
        return schemaElements;
    }

    protected List<SchemaElement> getMatchedDimensions(ChatQueryContext queryCtx, Long dataSetId) {
        List matchedElements = queryCtx.getMapInfo().getMatchedElements(dataSetId);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return Collections.emptyList();
        }
        List<SchemaElement> schemaElements = matchedElements.stream().filter(schemaElementMatch -> {
            SchemaElementType elementType = schemaElementMatch.getElement().getType();
            return SchemaElementType.DIMENSION.equals((Object)elementType);
        }).map(schemaElementMatch -> schemaElementMatch.getElement()).collect(Collectors.toList());
        return schemaElements;
    }

    protected Set<String> getMatchedFieldNames(ChatQueryContext queryCtx, Long dataSetId) {
        Map<Long, String> itemIdToName = this.getItemIdToName(queryCtx, dataSetId);
        List matchedElements = queryCtx.getMapInfo().getMatchedElements(dataSetId);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return new HashSet<String>();
        }
        Set<String> fieldNameList = matchedElements.stream().filter(schemaElementMatch -> {
            SchemaElementType elementType = schemaElementMatch.getElement().getType();
            return SchemaElementType.METRIC.equals((Object)elementType) || SchemaElementType.DIMENSION.equals((Object)elementType) || SchemaElementType.VALUE.equals((Object)elementType);
        }).map(schemaElementMatch -> {
            SchemaElement element = schemaElementMatch.getElement();
            SchemaElementType elementType = element.getType();
            if (SchemaElementType.VALUE.equals((Object)elementType)) {
                return (String)itemIdToName.get(element.getId());
            }
            return schemaElementMatch.getWord();
        }).collect(Collectors.toSet());
        return fieldNameList;
    }
}

