/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.llm;

import com.google.common.collect.Lists;
import com.tencent.supersonic.common.config.PromptConfig;
import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.headless.chat.parser.llm.ResponseHelper;
import com.tencent.supersonic.headless.chat.parser.llm.SqlGenStrategy;
import com.tencent.supersonic.headless.chat.parser.llm.SqlGenStrategyFactory;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMReq;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMResp;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.output.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OnePassSCSqlGenStrategy
extends SqlGenStrategy {
    private static final Logger log = LoggerFactory.getLogger(OnePassSCSqlGenStrategy.class);
    private static final String INSTRUCTION = "#SQL Syntax: Using SQL syntax for MySQL database.\n#Role: You are a data analyst experienced in SQL languages.\n#Task: You will be provided a natural language question asked by users,please convert it to a SQL query so that relevant data could be returned by executing the SQL query against underlying database.\n#Rules:1.ALWAYS use `\u6570\u636e\u65e5\u671f` as the date field.2.ALWAYS specify date filter using `>`,`<`,`>=`,`<=` operator.3.ALWAYS calculate the absolute date range by yourself.4.DO NOT include date filter in the where clause if not explicitly expressed in the question.5.ONLY respond with the converted SQL statement.\n#Exemplars:\n{{exemplar}}#Question:{{question}} #Schema:{{schema}} #SQL:";

    @Override
    public LLMResp generate(LLMReq llmReq) {
        keyPipelineLog.info("OnePassSCSqlGenStrategy llmReq:\n{}", (Object)llmReq);
        List<List<SqlExemplar>> exemplarsList = this.promptHelper.getFewShotExemplars(llmReq);
        HashMap<Prompt, List<SqlExemplar>> prompt2Exemplar = new HashMap<Prompt, List<SqlExemplar>>();
        for (List<SqlExemplar> exemplars : exemplarsList) {
            Prompt prompt2 = this.generatePrompt(llmReq, exemplars);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap prompt2Output = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            keyPipelineLog.info("OnePassSCSqlGenStrategy reqPrompt:\n{}", (Object)prompt.toUserMessage());
            ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(llmReq.getModelConfig());
            Response response = chatLanguageModel.generate(new ChatMessage[]{prompt.toUserMessage()});
            String result = ((AiMessage)response.content()).text();
            prompt2Output.put(prompt, result);
            keyPipelineLog.info("OnePassSCSqlGenStrategy modelResp:\n{}", (Object)result);
        });
        Pair<String, Map<String, Double>> sqlMapPair = ResponseHelper.selfConsistencyVote(Lists.newArrayList(prompt2Output.values()));
        LLMResp llmResp = new LLMResp();
        llmResp.setQuery(this.promptHelper.buildAugmentedQuestion(llmReq));
        llmResp.setDbSchema(this.promptHelper.buildSchemaStr(llmReq));
        llmResp.setSqlOutput((String)sqlMapPair.getLeft());
        llmResp.setSqlRespMap(ResponseHelper.buildSqlRespMap(exemplarsList.get(0), (Map)sqlMapPair.getRight()));
        return llmResp;
    }

    private Prompt generatePrompt(LLMReq llmReq, List<SqlExemplar> fewshotExampleList) {
        StringBuilder exemplarsStr = new StringBuilder();
        for (SqlExemplar exemplar : fewshotExampleList) {
            String exemplarStr = String.format("#Question:%s #Schema:%s #SQL:%s\n", exemplar.getQuestion(), exemplar.getDbSchema(), exemplar.getSql());
            exemplarsStr.append(exemplarStr);
        }
        String dataSemanticsStr = this.promptHelper.buildSchemaStr(llmReq);
        String questionAugmented = this.promptHelper.buildAugmentedQuestion(llmReq);
        HashMap<String, CharSequence> variable = new HashMap<String, CharSequence>();
        variable.put("exemplar", exemplarsStr);
        variable.put("question", questionAugmented);
        variable.put("schema", dataSemanticsStr);
        PromptConfig promptConfig = llmReq.getPromptConfig();
        String prompTemplate = INSTRUCTION;
        if (promptConfig != null && StringUtils.isNotBlank((CharSequence)promptConfig.getPromptTemplate())) {
            prompTemplate = promptConfig.getPromptTemplate();
        }
        return PromptTemplate.from((String)prompTemplate).apply(variable);
    }

    public void afterPropertiesSet() {
        SqlGenStrategyFactory.addSqlGenerationForFactory(LLMReq.SqlGenType.ONE_PASS_SELF_CONSISTENCY, this);
    }
}

