/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.llm;

import com.tencent.supersonic.common.pojo.SqlExemplar;
import com.tencent.supersonic.headless.chat.query.llm.s2sql.LLMSqlResp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHelper {
    private static final Logger log = LoggerFactory.getLogger(ResponseHelper.class);

    public static String getSql(String sqlOutput) {
        String sql = "";
        try {
            sqlOutput = sqlOutput.trim();
            String pattern = "SQL:(.*)";
            Pattern regexPattern = Pattern.compile(pattern);
            Matcher matcher = regexPattern.matcher(sqlOutput);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return sql;
    }

    public static Pair<String, Map<String, Double>> selfConsistencyVote(List<String> outputList) {
        HashMap<String, Integer> inputCounts = new HashMap<String, Integer>();
        for (String input : outputList) {
            inputCounts.put(input, inputCounts.getOrDefault(input, 0) + 1);
        }
        String inputMax = null;
        int maxCount = 0;
        int inputSize = outputList.size();
        HashMap<String, Double> votePercentage = new HashMap<String, Double>();
        for (Map.Entry entry : inputCounts.entrySet()) {
            String input = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count > maxCount) {
                inputMax = input;
                maxCount = count;
            }
            double percentage = (double)count / (double)inputSize;
            votePercentage.put(input, percentage);
        }
        return Pair.of(inputMax, votePercentage);
    }

    public static Map<String, LLMSqlResp> buildSqlRespMap(List<SqlExemplar> sqlExamples, Map<String, Double> sqlMap) {
        if (sqlMap == null) {
            return new HashMap<String, LLMSqlResp>();
        }
        return sqlMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> LLMSqlResp.builder().sqlWeight((Double)entry.getValue()).fewShots(sqlExamples).build()));
    }
}

