/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.chat.parser.rule;

import com.tencent.supersonic.common.pojo.enums.AggregateTypeEnum;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTypeParser
implements SemanticParser {
    private static final Logger log = LoggerFactory.getLogger(AggregateTypeParser.class);
    private static final Map<AggregateTypeEnum, Pattern> REGX_MAP = Stream.of(new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.MAX, Pattern.compile("(?i)(\u6700\u5927\u503c|\u6700\u5927|max|\u5cf0\u503c|\u6700\u9ad8|\u6700\u591a)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.MIN, Pattern.compile("(?i)(\u6700\u5c0f\u503c|\u6700\u5c0f|min|\u6700\u4f4e|\u6700\u5c11)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.SUM, Pattern.compile("(?i)(\u6c47\u603b|\u603b\u548c|sum)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.AVG, Pattern.compile("(?i)(\u5e73\u5747\u503c|\u65e5\u5747|\u5e73\u5747|avg)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.TOPN, Pattern.compile("(?i)(top)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.DISTINCT, Pattern.compile("(?i)(uv)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.COUNT, Pattern.compile("(?i)(\u603b\u6570|pv)")), new AbstractMap.SimpleEntry<AggregateTypeEnum, Pattern>(AggregateTypeEnum.NONE, Pattern.compile("(?i)(\u660e\u7ec6)"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));

    @Override
    public void parse(ChatQueryContext chatQueryContext) {
        String queryText = chatQueryContext.getQueryText();
        AggregateConf aggregateConf = this.resolveAggregateConf(queryText);
        for (SemanticQuery semanticQuery : chatQueryContext.getCandidateQueries()) {
            if (!AggregateTypeEnum.NONE.equals((Object)semanticQuery.getParseInfo().getAggType())) continue;
            semanticQuery.getParseInfo().setAggType(aggregateConf.type);
            int detectWordLength = 0;
            if (StringUtils.isNotEmpty((CharSequence)aggregateConf.detectWord)) {
                detectWordLength = aggregateConf.detectWord.length();
            }
            semanticQuery.getParseInfo().setScore(semanticQuery.getParseInfo().getScore() + (double)detectWordLength);
        }
    }

    public AggregateTypeEnum resolveAggregateType(String queryText) {
        AggregateConf aggregateConf = this.resolveAggregateConf(queryText);
        return aggregateConf.type;
    }

    private AggregateConf resolveAggregateConf(String queryText) {
        HashMap<AggregateTypeEnum, Integer> aggregateCount = new HashMap<AggregateTypeEnum, Integer>(REGX_MAP.size());
        HashMap<AggregateTypeEnum, String> aggregateWord = new HashMap<AggregateTypeEnum, String>(REGX_MAP.size());
        for (Map.Entry<AggregateTypeEnum, Pattern> entry2 : REGX_MAP.entrySet()) {
            Matcher matcher = entry2.getValue().matcher(queryText);
            int count = 0;
            String detectWord = null;
            while (matcher.find()) {
                ++count;
                detectWord = matcher.group();
            }
            if (count <= 0) continue;
            aggregateCount.put(entry2.getKey(), count);
            aggregateWord.put(entry2.getKey(), detectWord);
        }
        AggregateTypeEnum type = aggregateCount.entrySet().stream().max(Map.Entry.comparingByValue()).map(entry -> (AggregateTypeEnum)entry.getKey()).orElse(AggregateTypeEnum.NONE);
        String detectWord = (String)aggregateWord.get(type);
        return new AggregateConf(type, detectWord);
    }

    class AggregateConf {
        public AggregateTypeEnum type;
        public String detectWord;

        public AggregateConf(AggregateTypeEnum type, String detectWord) {
            this.type = type;
            this.detectWord = detectWord;
        }
    }
}

